/*
	segment.h	ȴ

	(C) Copyright 1995-98 by Personal Media Corporation
*/
#ifndef _KERNEL_SEGMENT_H_
#define _KERNEL_SEGMENT_H_

#include <basic.h>
#include <inner.h>
#include "pinfo.h"
#include <driver/driver.h>
#include <driver/disk.h>

#ifdef __cplusplus
extern "C" {
#endif

typedef struct {
	UW	blk;		/* ʪ֥åֹ */
	UW	len;		/* ʪ֥å */
} PhyBlk;

/*
 * ޥå׻
 */
typedef struct {
	UW	resv:3;
	UW	rank:3;		/* 󥯻 */
	UW	real:1;		/* ¡ۣɣϻ */
	UW	clear:3;	/* ꥢ */
	UW	level:6;	/* ٥ */
	UW	space:16;	/* ޥå׶ֻ */
	VP	addr;		/* ޥåץɥ쥹 */
	VW	info;		/* ޥå׾ */
} MapMode;

/* ޥåץꥢ */
typedef	enum {
	MapNoClr	= 0x0,	/* ꥢʤ */
	MapClr		= 0x1,	/* ꥢ */
	MapUnsettle	= 0x4,	/*  */
	MapNoClrTop	= 0x5,	/* Ƭ֥åϥꥢʤ */
	MapNoClrEnd	= 0x6	/* ǽ֥åϥꥢʤ */
} MapModeClr;

/* ޥåץ */
typedef	enum {
	MapRankPROG	= 0,	/* ץ¹ */
	MapRankMM0	= 1,	/* ޥ͡ */
	MapRankMM1	= 2,	/* ޥ͡(̤) */
	MapRankMM2	= 3,	/* ޥ͡(̤) */
	MapRankFM0	= 4,	/* եޥ͡(ǡ) */
	MapRankFM1	= 5,	/* եޥ͡() */
	MapRankFM2	= 6,	/* եޥ͡ */
	MapRankFM3	= 7	/* եޥ͡ */
} MapModeRank;

/* ٥ */
typedef enum {
#if CPU_ID == CPU_I386
	MapUser		= 0x02,
	MapSystem	= 0x00,
	MapRead		= 0x00,
	MapWrite	= 0x01,
	MapExecute	= 0x00
#else
	MapUser		= 0x08,
	MapSystem	= 0x00,
	MapRead		= 0x01,
	MapWrite	= 0x02,
	MapExecute	= 0x04
#endif
} MapModeLevel;

/*
 * 顼
 */
typedef struct {
	ERR	err;		/* 顼 */
	ID	diskid;		/* 顼ǥ ID */
	UW	blk;		/* 顼ǥʪ֥åֹ */
	ID	taskid;		/* ޥåפ ID */
	MapMode	mode;		/* 顼ޥåפ mode */
} DiskErrInfo;

/*
 * ե륷ƥ
 */
typedef struct {
	UH	lbsz;		/* ֥å (Х) */
	UH	btsz;		/* ֡ȥ֥å (Х) */
} FsSpec;

/*
 * ǥХץ⡼
 *	 ǥХΥץ⡼ɤ˽
 */
#define	D_ATTACH	0x0004	/* ե륷ƥ³ */
#define	D_READ		0x0001	/* ɹѥץ */
#define	D_WRITE		0x0002	/* ѥץ */
#define	D_UPDATE	0x0003	/* ѥץ */
#define	D_EXCL		0x0100	/* ¾⡼ɻ */
#define	D_WEXCL		0x0200	/* ¾񤭹ߥ⡼ɻ */

/*
 * UnmapDisk()  flag
 */
#define	MD_RDONLY	0x0000	/* ɤ߽ФΤ */
#define	MD_WRITE	0x0001	/* 񤭹ߤ */

/*
 * CheckSpace(),CheckStrSpace()  mode
 */
#define	MA_READ		4	/* ɤ߹ */
#define	MA_WRITE	2	/* 񤭹 */
#define	MA_EXECUTE	1	/* ¹ */

/*
 * MapMemory()  attr
 */
#if CPU_ID == CPU_I386
#define	MM_USER		0x04	/* 桼 */
#define	MM_SYSTEM	0x00	/* ƥ */
#define	MM_READ		0x00	/* ɤ߹ */
#define	MM_WRITE	0x02	/* 񤭹 */
#define	MM_EXECUTE	0x00	/* ¹ */
#define	MM_CDIS		0x18	/* åػ */
#endif

/*
 * 󥿡ե饤֥꼫ưѤ (for mkiflib)
 */
#ifdef DEFINE_IFLIB
[NAME]
ȴ	segmgr

[INCLUDE FILE]
<kernel/segment.h>

[PREFIX]
SEG
#endif

/* [BEGIN SYSCALLS] */
IMPORT WERR AttachFS(TC *devname, UW omode, PINFO *pinfo, DiskInfo *diskinfo);
IMPORT ERR  CheckFS(TC *devname, UW omode, PINFO *pinfo);
IMPORT ERR  DetachFS(ID diskid, PINFO *pinfo, Bool eject);
IMPORT ERR  SyncFS(ID diskid, VW info);
IMPORT WERR MapDisk(ID diskid, PhyBlk *block, MapMode *mode);
IMPORT ERR  UnmapDisk(ID mapid, UW flag);
IMPORT ERR  NotifyDiskErr(FP errhdr);
IMPORT ERR  InformFS(ID diskid, FsSpec *spec);

/* ALIGN_NO 0x100 */
IMPORT ERR  LockSpace( VP laddr, W len, ID taskid );
IMPORT ERR  UnlockSpace( VP laddr, W len, ID taskid );
IMPORT WERR CnvPhysicalAddr( VP laddr, W len, VP *paddr );
IMPORT ERR  CheckSpace( VP laddr, W len, UW mode, UW env );
IMPORT WERR CheckStrSpace( TC *str, W max, UW mode, UW env );
IMPORT WERR CheckBStrSpace( UB *str, W max, UW mode, UW env );
IMPORT WERR CheckSpaceLen( VP laddr, W len, UW mode, UW env, UW lsid );
IMPORT WERR ReadMemSpace( VP laddr, VP buf, W len, UW lsid );
IMPORT WERR WriteMemSpace( VP laddr, VP buf, W len, UW lsid );
IMPORT WERR SetMemSpaceB( VP laddr, W len, UB data, UW lsid );

/* ALIGN_NO 0x100 */
IMPORT ERR  MapMemory( VP paddr, W len, UW attr, VP *laddr );
IMPORT ERR  UnmapMemory( VP laddr );

#if VIRTUAL_ADDRESS
/* ALIGN_NO 0x1000 */
IMPORT ERR  MakeSpace( VP laddr, W npage, UW lsid, UW pte );
IMPORT ERR  UnmakeSpace( VP laddr, W npage, UW lsid );
IMPORT ERR  ChangeSpace( VP laddr, W npage, UW lsid, UW pte );
#endif
/* [END SYSCALLS] */

#ifdef __cplusplus
}
#endif
#endif
