/*
 *	@(#)solib.h 01-07-05
 *
 *	֥ͭ(SO)ݡȥ饤֥
 *	(C) Copyright 2001 by Personal Media Corporation
 */

#ifndef _KERNEL_SOLIB_H_
#define _KERNEL_SOLIB_H_
#ifdef __cplusplus
extern "C" {
#endif

#include <btron/dynload.h>
#include <btron/util.h>
#include <kernel/elf.h>
#include <bsys/queue.h>

typedef struct dlinfo	DLInfo;

/*
 * ܥ륹ץꥹ
 */
typedef struct {
	W		nent;		/* ȥ꡼ */
	DLInfo		**ent;		/* о (Ĺ) */
} DLScope;

/*
 * ֥ȴ
 */
struct dlinfo {
	QUEUE		q;		/* ³ */
	W		count;		/* ȥ */
	W		dllcount;	/* DLL ɥ */
	LINK		lnk;		/* ֥ͭȥե */
	W		ldid;		/* ID */
	P_DYNLDINF	ldinf;		/* ɾ */
	W		ldofs;		/* ɥեå */

	DLInfo		*loader;	/* ǽ˥ɤ (DLL)ᥤ */
	Bool		global:1;	/* Х륹פΤȤ True */
	Bool		relocated:1;	/* ѤߤΤȤ True */
	Bool		nowloading:1;	/* ǥΤȤ True */
	Bool		initcalled:1;	/* init ƤӽФȤ True */

	/* ɥ֥Ⱦ */
	Elf32_Dyn	*dyn;		/* ʥߥå */
	VP		*got;		/* Х륪եåȥơ֥
								DT_PLTGOT */
	Elf32_Rel	*reltab;	/* ơ֥ DT_REL */
	UW		relsz;		/*			DT_RELSZ */
	Elf32_Rel	*jreltab;	/* ơ֥ DT_JMPREL */
	UW		jrelsz;		/*			DT_PLTRELSZ */
	UB		*strtab;	/* ȥ󥰥ơ֥	DT_STRTAB */
	Elf32_Sym	*symtab;	/* ܥơ֥	DT_SYMTAB */
	struct hash {			/* ϥåơ֥	DT_HASH */
		UW	nbucket;
		UW	*bucket;
		UW	*chain;
	} hash;
	FP		init;		/* 롼	DT_INIT */
	FP		fini;		/* λ롼	DT_FINI */

	/* ܥ븡ꥹ */
	DLScope		search;		/* ¸饤֥ */

	/* ܥ륹ץꥹ */
	DLScope		*scope[4];	/* ɸॹ */
	DLScope		*lscope[2];	/* 륹 */
};
IMPORT DLInfo	__dlInfo;

#define	DLInfoID(dlp)	( (UW)(dlp) >> 2 )	/* ϥɥ */

/*
 * 󥯻Υɥ쥹ɤɥ쥹ؤѴ
 *	VP LDADR( DLInfo *dlp, VP vp )
 */
#define	LDADR(dlp, vp)	( (VP)((UW)(vp) + (dlp)->ldofs) )

/*
 * DLInfo Ѥ¾
 */
IMPORT ERR  __so_lock( Bool ignore_mintr );
IMPORT void __so_unlock( void );

/*
 * solib ȥ꡼
 */
IMPORT ERR __so_loading( DLInfo **dlpp, LINK *lnk, DLInfo *loader );
IMPORT ERR __so_depsloading( DLInfo *loader, UW global );
IMPORT ERR __so_relocate( DLInfo *loader, UW lazy );
IMPORT void __so_callinit( DLInfo *loader );
IMPORT void __so_callfini( DLInfo *loader );
IMPORT UW __so_resolve( DLInfo *dlp, UB *name, UW reltype, Elf32_Sym **sym );
IMPORT UW __so_localresolve( DLInfo *dlp, UB *name, DLInfo *skip, Elf32_Sym **sym );
IMPORT void __freeDLInfo( DLInfo *dlp );

#ifdef __cplusplus
}
#endif
#endif
