/*
	syscall.h	ƥॳ롦󥿡ե

	(C) Copyright 1995-97 by Personal Media Corporation
*/
#ifndef _KERNEL_SYSCALL_H_
#define _KERNEL_SYSCALL_H_

#include <basic.h>
#include <bsys/queue.h>
#include <kernel/svcno.h>

#ifdef __cplusplus
extern "C" {
#endif

#ifndef REGISTER
#define REGISTER(reg)	register W reg asm(#reg)
#endif

/*
 * ǽֹ
 */
typedef struct {
#if BIGENDIAN
	UW	funcno:16;	/* ӣ֣εǽֹ */
	UW	parsize:8;	/* ѥ᡼ץ */
	UW	svcno:8;	/* ӣֹ֣ */
#else
	UW	svcno:8;	/* ӣֹ֣ */
	UW	parsize:8;	/* ѥ᡼ץ */
	UW	funcno:16;	/* ӣ֣εǽֹ */
#endif
} EFN;

typedef union {
	EFN	efn;
	UW	w;
} FunctionNumber;

/*
 * ƥॳκ
 */
#define	MAX_SYSCALL_PARA	(10)

/*
 * ޥɥѥåȷ
 */
typedef struct {
	QUEUE		q;			/* 塼³ */
	FunctionNumber	fno;			/* ǽֹ */
	ID		tid;			/* ƤӽФ ID */
	W		ret;			/*  */
#if MACHINE_ID & PCAT
	VP		para;			/* ꥹȤؤΥݥ */
#else
	W		para[MAX_SYSCALL_PARA];	/* ꥹ */
#endif
     /*	VB		work[0];		   ΰ (ˡǤ) */
} SyscallCmdPacket;

/*
 * ǥָƤӽФμ
 */
typedef enum {
	Syscall_APL	= 0x00000001,	/* ץꥱ󤫤θƤӽФ */
	Syscall_OS	= 0x00000002,	/* OS ⤫θƤӽФ */
	Syscall_OWN	= 0x00000004	/* ȤˤƸƤӽФʤ */
} SyscallPattern;

#ifdef __cplusplus
}
#endif
#endif
