/*
 * libimg.h - image library(libimg) header file
 *
 * (C) Copyright 2001 by Personal Media Corporation.
 *
 * << NOTICE >>
 * This library is including libpng1.0.9, zlib1.1.3 and libjpeg-6b.
 */

#ifndef _LIBIMG_H_
#define _LIBIMG_H_

#include <typedef.h>
#include <errcode.h>
#include <btron/dp.h>
#include <tad.h>

#ifdef __cplusplus
extern "C" {
#endif

struct _libimg_compact {
  H method;   /*  */
  H opt;      /* method˰¸ץ */
};
typedef struct _libimg_compact IMG_COMPACT;

struct _libimg_bmp {
  CSPEC *color_spec;
  BMP   *bmap;
  ERR  (*funcptr)();  /* ɤ߽񤭤ԤؿؤΥݥ
			 writeξΰ:
			 (VOID* io_src, UB* bytes, UW size)
			 readξΰ:
			 (UB* bytes, UW reqsize, VOID* io_src) */
  VOID  (*flushptr)(); /* 񤭹 flushԤؿؤΥݥ */
  VOID  *io_src;       /* ɤ߽оݤؤΥݥ */
};
typedef struct _libimg_bmp IMG_BMP;

#define LIBIMG_METHOD_PNG  (1)
#define LIBIMG_METHOD_JPEG (2)
#define LIBIMG_METHOD_BMP  (3)

#define LIBIMG_PNG_OPT_BEST      (1)
#define LIBIMG_PNG_OPT_INTERLACE (8)
#define LIBIMG_PNG_OPT_DEFAULT LIBIMG_PNG_OPT_BEST

#define LIBIMG_PNG_READ_OPT_SAVE_ALPHA          (0x1000)
#define LIBIMG_PNG_READ_OPT_OVERWRITABLE_COLMAP (0x2000)

#define LIBIMG_JPEG_OPT_NONE              (0)
#define LIBIMG_JPEG_OPT_QUALITY_MASK      (0x007f)
#define LIBIMG_JPEG_OPT_DCT_MASK          (0x3000)
#define LIBIMG_JPEG_OPT_DCT_INT           (0x1000)
#define LIBIMG_JPEG_OPT_DCT_SLOW          LIBIMG_JPEG_OPT_DCT_INT
#define LIBIMG_JPEG_OPT_DCT_FAST          (0x2000)
#define LIBIMG_JPEG_OPT_DCT_FLOAT         (0x3000)
#define LIBIMG_JPEG_OPT_BASELINE          (0x4000)
#define LIBIMG_JPEG_OPT_PROGRESSION       (0x8000)
#define LIBIMG_JPEG_OPT_DEFAULT LIBIMG_JPEG_OPT_NONE

#define LIBIMG_JPEG_READ_OPT_1_8_SIZE     (0x0001)
#define LIBIMG_JPEG_READ_OPT_1_4_SIZE     (0x0002)
#define LIBIMG_JPEG_READ_OPT_1_2_SIZE     (0x0003)
#define LIBIMG_JPEG_READ_OPT_1_1_SIZE     (0x0000)

#define LIBIMG_BMP_OPT_DEFAULT (0)
#define LIBIMG_BMP_OPT_COMPRESS (1)
#define LIBIMG_BMP_READ_OPT_OVERWRITABLE_COLMAP LIBIMG_PNG_READ_OPT_OVERWRITABLE_COLMAP

/* ̥顼 */
#define LIBIMG_ERR_OK                       (0)
#define LIBIMG_ERR_READ_WRITE_ERROR         (-8001)
#define LIBIMG_ERR_NO_MEMORY                (-8002)
#define LIBIMG_ERR_ILLEGAL_PARAMETER        (-8003)

#define LIBIMG_PNG_ERR_CANNOT_CREATE_STRUCT (-8100)
#define LIBIMG_PNG_ERR_READ_WRITE_ERROR     LIBIMG_ERR_READ_WRITE_ERROR
#define LIBIMG_PNG_ERR_NO_MEMORY            LIBIMG_ERR_NO_MEMORY
#define LIBIMG_PNG_ERR_ILLEGAL_PARAMETER    LIBIMG_ERR_ILLEGAL_PARAMETER

#define LIBIMG_JPEG_ERR_READ_WRITE_ERROR    LIBIMG_ERR_READ_WRITE_ERROR
#define LIBIMG_JPEG_ERR_NO_MEMORY           LIBIMG_ERR_NO_MEMORY
#define LIBIMG_JPEG_ERR_ILLEGAL_PARAMETER   LIBIMG_ERR_ILLEGAL_PARAMETER

#define LIBIMG_BMP_ERR_READ_WRITE_ERROR    LIBIMG_ERR_READ_WRITE_ERROR
#define LIBIMG_BMP_ERR_NO_MEMORY           LIBIMG_ERR_NO_MEMORY

#define LIBIMG_METHOD_DEFAULT LIBIMG_METHOD_PNG
#define LIBIMG_OPTION_DEFAULT LIBIMG_PNG_OPT_DEFAULT

/*  */
IMPORT ERR libimg_wri_bmp(IMG_BMP* bmap, IMG_COMPACT* compact);
IMPORT ERR libimg_rea_bmp(IMG_BMP* bmap, IMG_COMPACT* compact);

/* ᡼¸δؿ */
IMPORT ERR libimg_wri_bmp_png(IMG_BMP* src, IMG_COMPACT* opt);
IMPORT ERR libimg_rea_bmp_png(IMG_BMP* dst, IMG_COMPACT* opt);
IMPORT ERR libimg_wri_bmp_jpeg(IMG_BMP* src, IMG_COMPACT* opt);
IMPORT ERR libimg_rea_bmp_jpeg(IMG_BMP* dst, IMG_COMPACT* opt);
IMPORT ERR libimg_wri_bmp_bmp(IMG_BMP* src, IMG_COMPACT* opt);
IMPORT ERR libimg_rea_bmp_bmp(IMG_BMP* dst, IMG_COMPACT* opt);

/*
 * TADȴط
 */
typedef struct {
  RECT  view;     /* ɽΰ */
  RECT  draw;     /* ΰ */
  UNITS h_unit;   /* ɸñ(ʿ) */
  UNITS v_unit;   /* ɸñ(ľ) */
  H     slope;    /*  */
  H     rsrv1;    /* ͽ */
  CSPEC* cspec;   /* 顼 */
  CBMP*  cbmp;    /* ̥ӥåȥޥå */
  UB*    mask;    /* ޥ */
  W      masksz;  /* ޥΥ */
  COLOR  bgcolor; /* طʿ */
  Bool   reverse; /* ȿžɽ */
} IMG_TADINFO;

IMPORT WERR libimg_rea_seg(IMAGESEG*    imgseg,
			   W            imgsegsz,
			   IMG_TADINFO* info);
IMPORT WERR libimg_wri_seg(IMAGESEG* imgseg,
			   IMG_TADINFO* info);

#ifdef __cplusplus
}
#endif
#endif
