/*
	winlib.h	ɥ饤֥إå

	(C) Copyright 1995-2000 by Personal Media Corporation
*/
#ifndef	_WINLIB_H_
#define	_WINLIB_H_

#include "bstdarg.h"

#ifdef __cplusplus
extern "C" {
#endif

typedef	W	Answer;
#define	Yes	1
#define	No	0

typedef	W	Status;
#define	Done	1
#define	NotDone	0

#define	GRNULL			((GRGN *)(NULL))
#define	HRNULL			((HRGN *)(NULL))

typedef	struct	{
	H	dh;
	H	dv;
} Displacement;

extern	GRGN	*RectGRgn(RECT r);
extern	RECT	*AndRect(RECT *dst, RECT *s1, RECT *s2);
extern	Answer	PtInGRgn(PNT pnt, GRGN *rgn);
extern	Answer	DoesIncludeGRgn(GRGN *sub, GRGN *obj);
extern	Answer	IsIncludedGRgn(GRGN *sub, GRGN *obj);
extern	Answer	IsSameShapeGRgn(GRGN *rgn1, GRGN *rgn2);
extern	Answer	IsSameGRgn(GRGN *rgn1, GRGN *rgn2);
extern	Answer	IsSameShapeGRgnWithDisp(GRGN *rgn1, GRGN *rgn2, Displacement *disp);
extern	RECT	MinimumRectOfGRgn(GRGN *rgn);
extern	Answer	IsEmptyGRgn(GRGN *rgn);
extern	GRGN	*CopyGRgn(GRGN *rgn);
extern	GRGN	*CopyAndNormalizeGRgn(GRGN *rgn);
extern	GRGN	*CreateGRgnWithList(W sx, W bx, ...);
extern	GRGN	*CreateGRgnWithNumberAndList(W sy, W nr, W bx, ...);
extern	GRGN	*CreateGRgnWithNumberAndVector(W sy, W nr, W bx, HRGN *hr[]);
extern	GRGN	*CreateGRgnWithVector(W sy, W bx, HRGN *hr[]);
extern	HRGN	*CreateHRgnWithList(W h1, ...);
extern	HRGN	*CreateHRgnWithNumberAndList(W nh, ...);
extern	HRGN	*CreateHRgnWithNumberAndVector(W nh, W hv[]);
extern	HRGN	*CreateHRgnWithVector(W hv[]);

extern	Status	DuplicateGRgn(GRGN *newr, GRGN *org, W len);

extern	void	GRgnToMask(GRGN *rgn, BMP *bmp);

extern	void	PtrToOffsetGRgn(GRGN *rgn);
extern	void	OffsetToPtrGRgn(GRGN *rgn);
extern	Status	DisposeGRgn(GRGN *rgn);
extern	GRGN*	CopyAndMoveGRgn(GRGN *rgn, Displacement *disp);
extern	Status	MoveGRgn(GRGN *rgn, Displacement *disp);
extern	GRGN	*MaskToGRgn(BMP *bmp);
extern	Status	NormalizeGRgn(GRGN *grgn);

extern	GRGN	*UnionGRgn(GRGN *rgn1, GRGN *rgn2);
extern	GRGN	*SectGRgn(GRGN *rgn1, GRGN *rgn2);
extern	GRGN	*DiffGRgn(GRGN *rgn1, GRGN *rgn2);
extern	GRGN	*XorGRgn(GRGN *rgn1, GRGN *rgn2);

extern	GRGN	*PolyToGRgn(POLY *poly);
extern	GRGN	*PolyToOutline(BMP *bmp, POLY *poly, PIXVAL bgcol, W frame);

extern	Status	ResizeGRgn(GRGN *rgn, RECT *frame);
extern	GRGN	*CopyAndResizeGRgn(GRGN *rgn, RECT *frame);
extern	GRGN	*RotateGRgn(GRGN *rgn, DEG ang);

extern	W	SizeGRgn(GRGN *rgn);

#ifdef __cplusplus
}
#endif
#endif
