/*
	machine.h	

	(C) Copyright 1995-98 by Personal Media Corporation

	ϡɥϣΥץåȥեΰ㤤򵭽Ҥ롣
	ɤ򡢥ץåȥեΰ㤤ʬʤФʤʤˡ
	ƤޥѤ롣

	ʤǤˤȽѤŪˤʬब
	˾ޤ롣㤨Сǥΰ㤤ϵ̾Ƕ̤BIGENDIAN 
	Ѥ롣

	 øΥեʳѤΤǡޥʳ
	   ʤȡ
*/

#ifndef __MACHINE_H__
#define __MACHINE_H__

/*
	BTRON_SPEC		BTRON ͤΥСɽ魯
	MACHINE_ID		ɣ (ӥåȥޥ)
	CPU_ID			ãУաݣɣ (ӥåȥޥ)
	ALLOW_MISALIGN		ߥ饤ȥǡΥǽʾ 
	BIGENDIAN		ӥåǥξ 
	VIRTUAL_ADDRESS		۵ξ 
	USE_PIC_PID		PIC/PID (Position Independent Code/Data) 
				Ѥ 
	USE_ROM_MODULE		ROM ˥ץ֤ƥξ 
	POWER_SAVE		ϴϢǽ(Ѥ) 
*/

/* TRON  (ITRON3.0 ɸϥɥ֥å) */
#define	SPEC_TRON	0x0000		/* TRON  (TAD) */
#define	SPEC_ITRON	0x1000		/* ITRON */
#define	SPEC_BTRON	0x2000		/* BTRON */
#define	SPEC_CTRON	0x3000		/* CTRON */
#define	SPEC_mITRON	0x5000		/* ITRON */
#define	SPEC_mBTRON	0x6000		/* BTRON */
#define	SPEC_MAGIC(n)	( (n) & 0xf000 )
#define	SPEC_VER(n)	( (n) & 0x0fff )

/* CPU  */
#define	CPU_TRON	0x00000001
#define	CPU_I386	0x00000010

/* ----- PC-AT  ----------------------------------------------------- */
#ifdef PCAT

#undef	PCAT
#define	PCAT			0x00000010
#define	MACHINE_ID		PCAT

#define	BTRON_SPEC		( SPEC_BTRON | 0x302 )
#define	CPU_ID			CPU_I386
#define	ALLOW_MISALIGN		1
#define	BIGENDIAN		0
#define	VIRTUAL_ADDRESS		1
#define	USE_PIC_PID		0
#define	USE_ROM_MODULE		0
#define	POWER_SAVE		1

#ifndef _Csym
#define	_Csym			0
#endif

#endif

/* =====  ========================================================= */

#ifdef __cplusplus
#define	Inline		inline
#else
#define	Inline		static __inline__
#endif
#define	Asm		__asm__ volatile

/*
 * C Υܥ
 *	_Csym = 0	_ ղäʤ
 *	_Csym = 1	_ ղä
 *
 *	 UNIX System V Release 4 Ϥ C ѥǤϡ
 *	   ܥ _ ղäʤ
 */
#if _Csym == 0
#define	Csym(sym)	sym
#else
#define	Csym(sym)	_##sym
#endif

#endif
