/*
 *	@(#)mtstring.h 00-02-28
 *
 *	(ץ)ꥳɤޤ TC ʸγƼ
 *	(C) Copyright 1999-2000 by Personal Media Corporation
 */

#ifndef __MTSTRING_H__
#define __MTSTRING_H__
#ifdef __cplusplus
extern "C" {
#endif

/*
 * ɽؤѴ
 *	src ʸɽѴ dst سǼ롣
 *	src ʸ TNULL ޤѴ롣TNULL ˽в len ʸ(TC ñ
 *	)ãϡlen ʸޤѴ롣len < 0 ξ
 *	len ̵뤵롣
 *	dst Ĺ len ʸʤϡlen ʸޤ TNULL 
 *	롣Ѵ̤礦 len ʸξϡTNULL ղäʤ
 *	len < 0 ξϡɬ TNULL ղä롣
 *	ͤѴ̤ʸ(dst) TNULL ޤޤʤĹ(TC ñ)֤
 *	dst  src ƱΥ꡼(dst == src)ꤹ뤳ȤǤ롣
 *	ʳΰνʣäưݾڤʤ
 */
IMPORT W mtc_unique( TC *dst, const TC *src, W len );

/*
 * ʸ
 *	ʸ c1  c2 (ץ)θӤ롣
 *	ޤ (1)(6) γΰʬषc1  c2 ۤʤΰ°Ƥ
 *	ϡΰֹ(16)οͤӤ롣
 *	Ʊΰ°Ƥϡc1  c2 ʸɤͤȤӤ롣
 *
 *		> 0 : c1 > c2
 *		= 0 : c1 = c2
 *		< 0 : c1 < c2
 *
 *		 00           7F 80           FF
 *		+-------------------------------+
 *	     00	|(1)	楳		|
 *		+---------------+---------------+
 *	     01	|(2)		|(4)		|
 *		|		|		|
 *		|	|	å|
 *	     7F	|		|		|
 *		+---------------+---------------+
 *	     80	|(3)		|(5)		|
 *		|		|		|
 *		|	¥|	ĥ|
 *	     FD |		|		|
 *		+---------------+---------------+
 *	     FE	|(6)	ꥳ		|
 *	     FF	|	ü쥳ɡ	|
 *		+-------------------------------+
 */
IMPORT W tc_chcmp( TC c1, TC c2 );

/*
 * ʸ
 *	ʸ s1  s2 Ӥ롣s1, s2 ϰɽǤʤФʤʤ
 *	s1  s2 Ƭ飱ʸӤǽ԰פȤʤäʸ羮
 *	ӷ̤Ȥ֤롣
 *	s1 ޤ s2  TNULL ˽в񤦤ޤӤ롣
 *	TNULL ˽в񤦤ޤ s1  s2 ʸ󤬰פƤϡ TNULL
 *	˽вäȽǤ롣
 *	Ӥϡ(ץ)ޤʸȤӤ롣ۤʤ(
 *	ץ)°ϡTLANG ͤˤäӤ롣
 *	Ʊ(ץ)°ϡtc_chcmp() ˤäӤ롣
 *
 *		> 0 : s1 > s2
 *		= 0 : s1 = s2
 *		< 0 : s1 < s2
 *
 *	mtc_strncmp() ϡ len ʸ(TC ñ)ޤӤ롣
 *	ʳ mtc_strcmp() Ʊ
 *
 *	()	s1 = [FE22]
 *		s2 = [FE22][FE21]
 *		ξϡ[FE22]  [FE21] Ӥ졢s1 > s2 Ȥʤ롣
 */
IMPORT W mtc_strcmp( const TC *s1, const TC *s2 );
IMPORT W mtc_strncmp( const TC *s1, const TC *s2, W len );

/*
 * ʸϢ
 *	ʸ dst θ src ɲä롣dst, src ϰɽǤʤФʤ
 *	ʤϢ뤵줿̤ dst ϰɽȤʤ롣
 *	dst  TNULL ΰ֤ src ɲä졢ɬü TNULL ղä롣
 *	dst κǸʸƥॹץȤʸǤʤСƥॹ
 *	ץȤθ(ץ)ꥳɤղä塢src ɲä롣
 *	ơdst ʸϡ dst + [FE21] + src + TNULL Ȥʤ롣
 *	ͤ dst ֤
 *
 *	mtc_strncat() ϡsrc ʸ len ʸ(TC ñ)ޤϢ뤹롣
 *	ʳ mtc_strcat() Ʊ
 */
IMPORT TC* mtc_strcat( TC *dst, const TC *src );
IMPORT TC* mtc_strncat( TC *dst, const TC *src, W len );

/*
 * ʣʸϢ
 *	ʸ s1, ...  len ʸ(TC ñ)ޤϢ뤷 dst سǼ롣
 *	Ϣ뤹ʸοǤդǡǸ NULL ꤹ롣
 *	s1, ... ϰɽǤʤƤ褤̤ dst ϰɽȤʤ롣
 *	len  TNULL ޤޤʤĹ
 *	dst νüˤɬ TNULL ղä롣äơdst  len + 1 ʸ
 *	(TC)ʬΰ褬ɬס
 *	̤ʸ TNULL Ĺ(TC ñ)֤ͤ
 *	dst  s1 ƱΥ꡼(dst == s1)ꤹ뤳ȤǤ롣ʳ
 *	ΰνʣäưݾڤʤ
 *	ܰʹߤʸ dst ΰ˽ʣäưݾڤʤ
 *
 *	()	mtc_strjoin(dst, len, s1, s2, s3, NULL);
 */
IMPORT W mtc_strjoin( TC *dst, W len, const TC *s1, ... );

/*
 * ʸɲ
 *	ʸ dst θ apd  len ʸ(TC ñ)Ķʤ褦ɲä롣
 *	len ʸĶƤޤϡdst θʸơapd ɲä
 *	롣len  TNULL ޤʤĹdst νüˤɬ TNULL ղä
 *	ǡdst  len + 1 ʸ(TC)ʬΰ褬ɬס
 *	dst, apd ϰɽǤʤФʤʤ̤ dst ϰɽȤʤ롣
 *	ͤ˷̤ TNULL ޤʤʸ(TC ñ)֤
 *	apd  len ʸĹη̤ݾڤʤ
 */
IMPORT W mtc_strapd( TC *dst, const TC *apd, W len );

/*
 * ʸ
 *	str ʸ˴ޤޤʸ롣
 *	(ץ)ꥳɤϡʸ˴ޤʤ
 *
 *	mtc_strnlen() ϡstr κ n TCĤޤǤ˴ޤޤʸ롣
 */
IMPORT W mtc_strlen( const TC *str );
IMPORT W mtc_strnlen( const TC *str, W n );

/*
 * ʸθ
 *	str ʸ󤫤顢lang ǻꤷ(ץ) ch ʸõ
 *	ʸü TNULL ⸡оݤȤʤ롣
 *	str ϰɽǤʤФʤʤ
 *	mtc_strchr() ϡstr Ƭ齪üظäõ
 *	mtc_strrchr() ϡstr νüƬظäõ
 *	ǽ˸Ĥä֤֤ͤĤʤä NULL ֤
 *
 *	lang = 0 ޤ ch = TNULL ξ lang ̵뤵졢٤Ƥθ(
 *	ץ)оݤ ch ʸõ
 */
IMPORT TC* mtc_strchr( const TC *str, TC ch, W lang );
IMPORT TC* mtc_strrchr( const TC *str, TC ch, W lang );

/*
 * ɽǤʤʸоݤȤʸθ
 *	str ʸ󤫤顢clang ǻꤷ(ץ) ch ʸõ
 *	ʸü TNULL ⸡оݤȤʤ롣
 *	str ʸ *slang ǻꤷ(ץ)ǻϤޤΤȤ롣
 *	 str Ƭ齪üظäƹԤ롣
 *	ǽ˸Ĥä֤֤ͤʸθ(ץ) *slang
 *	֤Ĥʤäͤ NULL ֤*slang ˤʸ
 *	üθ(ץ)֤롣
 *
 *	clang = 0 ޤ ch = TNULL ξ clang ̵뤵졢٤Ƥθ
 *	(ץ)оݤ ch ʸõ
 */
IMPORT TC* mtc_strchr2( const TC *str, W *slang, TC ch, W clang );

/*
 * ʸ֤
 *	str ʸ n ʸܤʸΰ֤ȸ(ץ)Ĵ٤롣
 *	str ϰɽǤʤФʤʤ
 *	ͤʸ֡*lang ˤʸθ(ץ)֤롣
 *	n ϡ(ץ)ꥳɤޤ᤺˿ʸǽʸ
 *	Ȥʤ롣
 *	n  str ˴ޤޤʸĶƤ硢 n < 0 ξϡ
 *	 NULL Ȥʤ롣ξ硢*lang ˤ str νüθ(ץ)
 *	֤롣
 */
IMPORT TC* mtc_strpos( const TC *str, W n, W *lang );

/*
 * ʸ֤θ(ץ)
 *	str ʸ p ΰ֤ʸθ(ץ)Ĵ٤롣
 *	str ϰɽǤʤФʤʤ
 *	ͤˤʸθ(ץ)֤
 *	p ΰ֤(ץ)ꥳɤǤä硢 p ΰ֤
 *	str ʸ˴ޤޤƤʤϡͤˣ֤롣
 */
IMPORT W mtc_poslang( const TC *str, const TC *p );

#ifdef __cplusplus
}
#endif
#endif
