/*
	sock_com.h	åȥ󥿥ե

	(C) Copyright 1998-2001 by Personal Media Corporation
*/
#ifndef	_SOCK_COMMON_H_
#define	_SOCK_COMMON_H_

#ifdef __cplusplus
extern "C" {
#endif

/*
	ץȥեߥ
*/
#define	PF_UNSPEC	0		/* unspecified protocol family */
#define	PF_INET		2		/* TCP/IP and related */

/*
	ɥ쥹եߥ
*/
#define	AF_UNSPEC	0		/* unspecified address family */
#define	AF_INET		2		/* TCP/IP and related */

/*
	åȥ
*/
#define	SOCK_STREAM	1		/* stream socket */
#define	SOCK_DGRAM	2		/* datagram socket */
#define	SOCK_RAW	3		/* raw-protocol interface */

/*
	ץ : getsockopt, setsockopt
*/
#define	SOL_SOCKET	0xffff		/* options for socket level */

#ifdef	BRV_R1
#define	IPPROTO_TCP	0x0001		/* options for TCP level */
#define	IPPROTO_IP	0x0002		/* options for IP level */
#else
#define	IPPROTO_TCP	0x0006		/* options for TCP level */
#define	IPPROTO_IP	0x0000		/* options for IP level */
#endif

#define	SO_DEBUG	0x0001		/* turn on debugging info recording */
#define	SO_REUSEADDR	0x0004		/* allow local address reuse */
#define	SO_KEEPALIVE	0x0008		/* keep connections alive */
#define	SO_DONTROUTE	0x0010		/* just use interface addresses */
#define	SO_BROADCAST	0x0020		/* permit sending of broadcast msgs */
#define	SO_LINGER	0x0080		/* linger on close if data present */
#define	SO_OOBINLINE	0x0100		/* leave received OOB data in line */
#define	SO_SNDBUF	0x1001		/* send buffer size */
#define	SO_RCVBUF	0x1002		/* receive buffer size */
#define	SO_ERROR	0x1007		/* get error status and clear */
#define	SO_TYPE		0x1008		/* get socket type */

#ifdef	BRV_R1
#define	TCP_MAXSEG	0x2000		/* maximum segment size */
#define	TCP_NODELAY	0x2001		/* immediate send() */
#else
#define	TCP_MAXSEG	0x0002		/* maximum segment size */
#define	TCP_NODELAY	0x0001		/* immediate send() */
#endif

#define	IP_OPTIONS	0x0001		/* IP header options */

/*
	ץ : recv, send
*/
#define MSG_OOB		0x01		/* send or receive out of band data */
#define MSG_PEEK	0x02		/* take data but leave it */
#define MSG_DONTROUTE	0x04		/* do not route */

/*
	ץ : fcntl
*/
#define O_NDELAY	0x04		/* non-blocking */
#define FNDELAY 	O_NDELAY	/* synonym */
#define F_GETFL		3		/* get flags */
#define F_SETFL		4		/* set flags */

/*
	ץ : ioctl
*/
#ifdef	BRV_R1
#define SIOCATMARK	7		/* check for out of bound data */
#define FIONREAD	127		/* number of bytes to read */
#else
#define SIOCATMARK	(0x40000000 | (4 << 16) | ('s' << 8) | 7)
					/* check for out of bound data */
#define FIONBIO 	(0x80000000 | (4 << 16) | ('f' << 8) | 126)
					/* set/clear non-blocking I/O */
#define FIONREAD	(0x40000000 | (4 << 16) | ('f' << 8) | 127)
					/* number of bytes to read */
#endif
#define SIOSELTMO	(0x80000000 | (4 << 16) | ('s' << 8) | 255)
					/* set/clear select timeout */

/*
	ɥ쥹
*/
struct sockaddr {
	unsigned short	sa_family;	/* address family */
	char		sa_data[14];	/* up to 14 bytes of direct address */
};

/*
	󥿡ͥåȥɥ쥹
*/
struct in_addr {
	unsigned long	s_addr;
};

#define	INADDR_ANY		(unsigned int)0x00000000
#define INADDR_LOOPBACK         (unsigned int)0x7F000001  /* 127.0.0.1 */
#define	INADDR_BROADCAST	(unsigned int)0xffffffff  /* must be masked */

/*
	åȥɥ쥹
*/
struct sockaddr_in {
	short		sin_family;	/* address family, must be unsigned */
	unsigned short	sin_port;	/* port number, nutwork byte order */
	struct in_addr	sin_addr;	/* sockect address */
	char		sin_zero[8];	/* zero padding */
};

/*
	I/O ٥ȥ
*/
struct iovec {				/* address and length */
	char		*iov_base;	/* base */
	int		iov_len;	/* size */
};

/*
	åإå : recvmsg, sendmsg
*/
struct msghdr { 			/* Message header */
	char	*msg_name;		/* optional address */
	int	msg_namelen;		/* size of address */
	struct iovec	*msg_iov;	/* scatter/gather array */
	int	msg_iovlen;		/* # elements in msg_iov */
	char	*msg_accrights;		/* access rights sent/received */
	int	msg_accrightslen;	/* sizeof access rights */
};

/*
	host ȥ : gethostbyname
*/
struct hostent {			/* structure for gethostbyname */
	char	*h_name;		/* official name of host */
	char	**h_aliases;		/* alias list */
	int	h_addrtype;		/* host address type */
	int	h_length;		/* length of address */
	char	**h_addr_list;		/* list of addresses from name server*/
#define	h_addr	h_addr_list[0]		/* address, for backward compatiblity*/
};

/*
	server ȥ : getservbyname
*/
struct servent {			/* structure for getservbyname */
	char	*s_name;		/* official service name */
	char	**s_aliases;		/* alias list */
	int	s_port;			/* port # */
	char	*s_proto;		/* protocol to use */
};

/*
	ץ : SO_LINGER
*/
struct linger {				/* structure for the SO_LINGER opt. */
	int	l_onoff;		/* zero=off, nonzero = on */
	int	l_linger;		/* linger time, in seconds */
};

/*
	ӥåȥޥ : slecect
*/
#ifndef	FD_SETSIZE

#define	FD_SETSIZE	256

#ifdef	BRV_R1
#define	SINT		sizeof(int)
#define	FD_SET(n, p)	((p)->fds_bits[(n)/SINT] |= (1 << ((n) % SINT)))
#define	FD_CLR(n, p)	((p)->fds_bits[(n)/SINT] &= ~(1 << ((n) % SINT)))
#define	FD_ISSET(n, p)	((p)->fds_bits[(n)/SINT] & (1 << ((n) % SINT)))
#define	FD_ZERO(p)	memset((void *)(p), 0, sizeof (*(p)))
typedef struct fd_set {		/* Bit mask for select() */
	int	fds_bits[FD_SETSIZE/sizeof(int)];
} fd_set;
#else
#define NFDBITS		(sizeof(long) * 8)	/* bits per mask */
#define FD_SET(n, p)	((p)->fds_bits[(n)/NFDBITS] |= (1 << ((n) % NFDBITS)))
#define FD_CLR(n, p)	((p)->fds_bits[(n)/NFDBITS] &= ~(1 << ((n) % NFDBITS)))
#define FD_ISSET(n, p)	((p)->fds_bits[(n)/NFDBITS] & (1 << ((n) % NFDBITS)))
#define FD_ZERO(p)	memset((void *)(p), 0, sizeof (*(p)))
typedef struct fd_set { 	/* Bit mask for select() */
	long	fds_bits[(FD_SETSIZE + NFDBITS - 1) / NFDBITS];
} fd_set;
#endif

#endif

/*
	ॢ : select
*/
struct timeval {			/* Timeout format for select() */
	long	tv_sec;			/* seconds */
	long	tv_usec;		/* microseconds */
};

#ifdef __cplusplus
}
#endif

#endif	/* _SOCK_COMMON_H_ */
