/*
	tctype.h	TRON ɤΥ饹Ƚ

	(C) Copyright 1995 by Personal Media Corporation
*/
#ifndef	_TCTYPE_H_
#define	_TCTYPE_H_

#include <tcode.h>

#define	tc_isdigit(c)	((c) >= TK_0 && (c) <= TK_9)
#define	tc_islower(c)	((c) >= TK_a && (c) <= TK_z)
#define	tc_isupper(c)	((c) >= TK_A && (c) <= TK_Z)
#define	tc_isalpha(c)	(tc_islower(c) || tc_isupper(c))
#define	tc_isalnum(c)	(tc_isdigit(c) || tc_isalpha(c))
#define	tc_isspace(c)	((c)==TK_KSP || (c)==TK_SP0 || (c)==TK_SP1 || (c)==TK_TAB)
#define	tc_toupper(c)	(tc_islower(c) ? ((c) - TK_a + TK_A) : (c))
#define	tc_tolower(c)	(tc_isupper(c) ? ((c) - TK_A + TK_a) : (c))

#define	tc_ischoon(c)	((c) == 0x213c)
#define	tc_ishira(c)	(((c) >= 0x2421 && (c) <= 0x2473) || tc_ischoon(c))
#define	tc_iskata(c)	(((c) >= 0x2521 && (c) <= 0x2576) || tc_ischoon(c))

#ifdef __cplusplus
extern "C" {
#endif
/* 
 * ʸåȽ
 * 	ܸ̤ʸcJIS X 0208:1997Ƥ True ֤
 */
IMPORT Bool tc_isjisx0208( TC c );

#ifdef __cplusplus
}
#endif

#endif /* _TCTYPE_H_ */
