/*
 *	@(#)tlang.h 00-08-12
 *
 *	(ץ)꡿¾
 *	(C) Copyright 1999-2000 by Personal Media Corporation
 */

#ifndef __TLANG_H__
#define __TLANG_H__
#ifdef __cplusplus
extern "C" {
#endif

/*
 * (ץ)ꥳ
 *	0xAABB	AA : FE η֤ݣ
 *		BB : FE ³
 *
 *	()	FE21      -> 0x0021
 *		FEFE 0021 -> 0x0121
 *		FEFE FE21 -> 0x0221
 */
typedef	UH	TLANG;

/*
 * ץȻꥳ (TLANG)
 */
#define	TSC_SYS		0x0021	/* ƥ */
#define	TSC_JPN1	0x0022	/* ܣ */
#define	TSC_JPN2	0x0023	/* ܣ */

#define TSC_CNS1	0x0026	/* CNS-11643 */
#define TSC_CNS2	0x0027	/* CNS-11643 */

#define TSC_DKW1	0x0028	/* £ */
#define TSC_DKW2	0x0029	/* £ */
#define TSC_JPNA	0x0029	/* ɲ */

#define TSC_MJK1	0x002b	/* () */
#define TSC_MJK2	0x002c	/* () */
#define TSC_MJK3	0x002d	/* () */

#define TSC_UNI1	0x0030	/* ƹ */
#define TSC_UNI2	0x0031	/* ƹ */

#define	TSC_MIN		0x0021
#define	TSC_MAX		0x003f

#if 0 /* (990205) ̤ */
/*
 * ꥳ (TLANG)
 */
#define	TLC_JPN0	0x0040	/* ܣ */
#define	TLC_JPN1	0x0041	/* ܣ */
#define	TLC_JPN2	0x0042	/* ܣ */
#endif

/*
 * TLANG ͤͭǧ
 *	(ץ)ꥳɤȤͭǤ True ֤
 */
Inline Bool isValidTLANG( W lang )
{
	UW	i = lang & 0xff;
	if ( (UW)lang >= 0x8000 ) return False;
	if ( i < 0x21 || i == 0x7f || i > 0xfd ) return False;
	return True;
}

/*
 * Ƚ
 *	ʸΥ˴ޤޤƤ True ֤
 */
Inline Bool inZone( TC c, TC lt, TC rb )
{
	UW	c1 = c >> 8;
	UW	c2 = c & 0xff;
	return (   c1 >= ((UW)lt >> 8)   && c1 <= ((UW)rb >> 8)
		&& c2 >= ((UW)lt & 0xff) && c2 <= ((UW)rb & 0xff) )?
		True: False;
}
#define	isAZone(c)	inZone(c, 0x2121, 0x7e7e)	/* A  */
#define	isBZone(c)	inZone(c, 0x8021, 0xfd7e)	/* B  */
#define	isCZone(c)	inZone(c, 0x2180, 0x7efd)	/* C  */
#define	isDZone(c)	inZone(c, 0x8080, 0xfdfd)	/* D  */
Inline Bool isADZone( TC c )				/* AD  */
{
	UW	c1 = c >> 8;
	UW	c2 = c & 0xff;
	return (   c1 >= 0x21 && c1 != 0x7f && c1 <= 0xfd
		&& c2 >= 0x21 && c2 != 0x7f && c2 <= 0xfd )? True: False;
}

/*
 * (ץ)ꥳȽ
 *	tp ʸ󤬸ꥳɤǤ뤫Ƚꤹ롣
 *		> 0	ꥳ (TLANG )
 *		= 0	ꥳɤǤʤ
 *		= -1	ꥳ
 *		= -2	̤ꥳ (ꥳɤǽäƤ)
 *
 *	len	tp ʸͭĹ(TC ñ)
 *		TNULL  len ʸޤǤоݤȤʤ롣
 *		0 ꤹ len ̵Ȥʤ TNULL ޤǤоݤȤʤ롣
 *	ntp	ꥳɤμʸΰ֤֤
 *		NULL ꤹ֤ʤ
 *
 *	()	FE21			 = 0x0021	*ntp = tp + 1
 *		FEFE 0021		 = 0x0121	*ntp = tp + 2
 *		2121			 = 0	*ntp = tp
 *		FE00			 = -1	*ntp = tp + 1
 *		FEFE 2121		 = -1	*ntp = tp + 2
 *		FEFE 0000		 = -2	*ntp = tp + 1
 *		FEFE 0021  (len = 1)	 = -2	*ntp = tp + 1
 *
 *	isTLANGce() ϡtp ʸ ConvEndianH() ˤꥨǥѴ
 *	Ƚꤹ롣ʳ isTLANG() Ʊ
 */
IMPORT W isTLANG( const TC *tp, W len, TC **ntp );
IMPORT W isTLANGce( const TC *tp, W len, TC **ntp );

/*
 * (ץ)ꥳȽ
 *	ʸ(TC)ĸꥳɤȽꤹ롣
 *		> 0	ꥳ (TLANG )
 *		= 0	ꥳɤǤʤ
 *		= -1	ꥳ
 *		= -2	̤ꥳ (ꥳɤ)
 *
 *	θƽл *n = 0 ˽Ƥʸϡ֤줿 *n ͤ
 *	ѹ˷֤ƤӽФȤǡꥳɤȽꤹ롣
 *
 *	()
 *		n = 0;
 *		while ( (lang = isTLANGch(*tp++, &n)) == -2 );
 */
IMPORT W isTLANGch( TC ch, W *n );

/*
 * ꥳ(TLANG) TC Ѵ
 *	lang θꥳɤ TC Ѵ tp سǼ롣
 *	Ǹ TNULL դ
 *	ͤ lang  TC Ѵ뤿ɬפĹ(TC ñ)֤
 *	Ǹ TNULL ʬϴޤޤʤ
 *	TC Ĺ max Ķ max ޤǳǼ롣äơ
 *	 > max ξϡǼƤʤȤ򼨤
 *	max < 0 ξ max ̵뤵롣
 *	tp = NULL ξ硢TC ϳǼ줺TC ĹΤߤ֤ͤ
 *	 lang ꤷη̤ݾڤʤ
 */
IMPORT W TLANGtoTC( TC *tp, W max, TLANG lang );

/*
 * ꥳ(TLANG) TC Ѵ (ꥳɤΥå)
 *	lang ǤСTC ؤѴϹԤ줺ĹȤʤ롣
 *	ξ TNULL Ͻ񤭽Ф롣
 *	lang ͭǤ TLANGtoTC() ƱǤ롣
 */
IMPORT W TLANGtoTCvc( TC *tp, W max, W lang );

#ifdef __cplusplus
}
#endif
#endif
