/*
	tstring.h	TC ʸ饤֥

	(C) Copyright 1995-2000 by Personal Media Corporation
*/
#ifndef __TSTRING_H__
#define __TSTRING_H__
#ifdef __cplusplus
extern "C" {
#endif

/* ʸ */
extern W tc_strcmp(const TC *s1, const TC *s2);
extern W tc_strncmp(const TC *s1, const TC *s2, W len);

/* ʸϢ */
extern TC* tc_strcat(TC *dest, const TC *src);
extern TC* tc_strncat(TC *dest, const TC *src, W len);

/* ʸ󥳥ԡ */
extern TC* tc_strcpy(TC *dest, const TC *src);
extern TC* tc_strncpy(TC *dest, const TC *src, W len);

/* ʸؿ */
extern TC* tc_strset(TC *str, TC ch, W len);
extern W   tc_strlen(const TC *str);

/* ʸ󸡺 */
extern TC* tc_strchr(const TC *str, int ch);
extern TC* tc_strrchr(const TC *str, int ch);

/* ʸѴ */
extern int  tc_atoi(const TC *str);
extern long tc_atol(const TC *str);
extern long tc_strtol(const TC *str, TC **tail, int base);

IMPORT	const TC	_asctotc[];

/*  EUC ==> TC ʸѴ
	euc ΰ EUC ʸ TC ʸѴ tc ˳Ǽ롣
	ѴХȿ(ޤϣ)ؿͤȤ᤹
	tc == NULL λϡѴ̤ϳǼʤؿ᤹ͤ
	ѴǤʤϴؿ͡euc ʸλϴؿ᤹ͣ
*/
extern	W	euctotc(TC *tc, const B *euc);

/* TC ==> EUC ʸѴ
	TC Σʸ EUC ΣʸѴ euc ˳Ǽ롣
	ѴХȿ(ޤϣ)ؿͤȤ᤹
	euc == NULL λϡѴ̤ϳǼʤؿ᤹ͤ
	ѴǤʤϴؿ͡tc == TNULL ξϴؿ᤹ͣ
*/
extern	W	tctoeuc(B *euc, TC tc);

/* EUC ==> TC ʸѴ
	EUC ʸTC ʸѴ롣
	Ѵ TC ʸĹ((tc_strlen(tcstr)) ᤹
	tcstr == NULL λϡѴ̤ϳǼʤؿ᤹ͤ
	ѴǤʤϴؿ᤹͡
*/
extern	W	eucstotcs(TC *tcstr, const B* eucstr);

/*  TC ==> EUC ʸѴ
	TC ʸ EUC ʸѴ롣
	Ѵ EUC ʸĹ(strlen(eucstr)) ᤹
	eucstr == NULL λϡѴ̤ϳǼʤؿ᤹ͤ
	ѴǤʤϴؿ᤹͡
*/
extern	W	tcstoeucs(B* eucstr, const TC* tcstr);

/* TC ʸ */
extern	TC	*tc_gets(TC *str);

/* TC ʸ */
extern	W	tc_puts(const TC *str);

/*	format print ɲá
	'S' Ѵ:	TC ʸ EUC ʸѴƽ
	'C' Ѵ	TC ʸ EUC ʸѴƽ
*/

/*  Shift-JIS ==> TC ʸѴ
	sj ΰ S-JIS ʸ TC ʸѴ tc ˳Ǽ롣
	ѴХȿ(ޤϣ)ؿͤȤ᤹
	tc == NULL λϡѴ̤ϳǼʤؿ᤹ͤ
	ѴǤʤϴؿ͡sj ʸλϴؿ᤹ͣ
*/
extern	W	sjtotc(TC *tc, const UB *sj);

/* TC ==> Shift-JIS ʸѴ
	TC Σʸ S-JIS ΣʸѴ sj ˳Ǽ롣
	ѴХȿ(ޤϣ)ؿͤȤ᤹
	euc == NULL λϡѴ̤ϳǼʤؿ᤹ͤ
	ѴǤʤϴؿ͡tc == TNULL ξϴؿ᤹ͣ
*/
extern	W	tctosj(UB *sj, TC tc);

/* Shift-JIS ==> TC ʸѴ
	S-JIS ʸTC ʸѴ롣
	Ѵ TC ʸĹ((tc_strlen(tcstr)) ᤹
	tcstr == NULL λϡѴ̤ϳǼʤؿ᤹ͤ
	ѴǤʤϴؿ᤹͡
*/
extern	W	sjstotcs(TC *tcstr, const UB* sjstr);

/*  TC ==> Shift-JIS ʸѴ
	TC ʸ S-JIS ʸѴ롣
	Ѵ S-JIS ʸĹ(strlen(sjstr)) ᤹
	sjstr == NULL λϡѴ̤ϳǼʤؿ᤹ͤ
	ѴǤʤϴؿ᤹͡
*/
extern	W	tcstosjs(UB* sjstr, const TC* tcstr);

#ifdef __cplusplus
}
#endif
#endif
