/*
	debug.h		ǥХåݡ

	(C) Copyright 1995-97 by Personal Media Corporation
*/
#ifndef	__DEBUG_H__
#define	__DEBUG_H__

#include <basic.h>

/*
 * 
 *	DEBUG_PRINT(("error = %d\n", err));
 *
 *	DO_DEBUG( if ( err < ER_OK ) DEBUG_PRINT(("error = %d\n", err)); )
 */
#ifdef DEBUG

#include <bstdio.h>
#include "libdbg.h"

#ifdef DEBUG_MODULE
#define DEBUG_PRINT(arg)						\
	(								\
		printf("%s#%d%s:", __FILE__, __LINE__, DEBUG_MODULE),	\
		printf arg						\
	)
#define BMS_DEBUG_PRINT(arg)						\
	(								\
		bms_printf("%s#%d%s:", __FILE__, __LINE__, DEBUG_MODULE), \
		bms_printf arg						\
	)
#else
#define DEBUG_PRINT(arg)						\
	(								\
		printf("%s#%d:", __FILE__, __LINE__),			\
		printf arg						\
	)
#define BMS_DEBUG_PRINT(arg)						\
	(								\
		bms_printf("%s#%d:", __FILE__, __LINE__),		\
		bms_printf arg						\
	)
#endif

#define	DO_DEBUG(exp)	{ exp }

#define	free(p)		{						\
	if ( p == NULL ) DEBUG_PRINT(("free(NULL)\n"));			\
	free(p);							\
}

#else /* DEBUG */

#define DEBUG_PRINT(arg)	/* arg */
#define BMS_DEBUG_PRINT(arg)	/* arg */
#define	DO_DEBUG(exp)		/* exp */

#endif /* DEBUG */

/*
 * Warning message
 *	WARNING(err != ER_OK, "warning message");
 */
#ifndef NDEBUG

#include <bsyslog.h>

#ifdef DEBUG_MODULE
#define	WARNING(cond, msg)						\
	if ( cond ) syslog(LOG_WARNING, "warning!%s#%d%s:%s",		\
				__FILE__, __LINE__, DEBUG_MODULE, msg)
#else
#define	WARNING(cond, msg)						\
	if ( cond ) syslog(LOG_WARNING, "warning!%s#%d:%s",		\
				__FILE__, __LINE__, msg)
#endif

#else /* NDEBUG */

#define	WARNING(cond, msg)	/* */

#endif /* NDEBUG */

#endif
