/*
 *	@(#)wtstring.h 00-02-28
 *
 *	磻TRONʸ()γƼ
 *	(C) Copyright 1999-2000 by Personal Media Corporation
 */

#ifndef __WTSTRING_H__
#define __WTSTRING_H__
#ifdef __cplusplus
extern "C" {
#endif

/*
 * 磻TRONʸ
 *	磻TRONʸ32bitդǤꡢ2ĤǤǹ롣
 *		0xxxxxxx xxxxxxxx yyyyyyyy yyyyyyyy (2ɽ)
 *              MSB                             LSB
 *
 *		 xxxxxxx xxxxxxxx: ꥳ(0x0000, 0x0021, 0x7fff)
 *		yyyyyyyy yyyyyyyy: ʸ
 *
 *	: TLANG
 *		0 ξϸ¸ʸ(ʸ)
 *		0x7fffξʸꥳɤɽ
 *	ʸ: TC
 */
typedef W	WTC;

/*
 * 磻TRONʸؤѴ
 *	ꥳlang, ʸtcǤ磻TRONʸ᤹
 *	lang, tcΥåϹԤʤ
 */
#define towtc(lang, tc) (((WTC)(lang) & 0x7fff) << 16 | ((WTC)(tc) & 0xffff))

/*
 * 磻TRONʸǤμФ
 *	磻TRONʸwtc顢ꥳɤ⤷ʸɤФ
 *	᤹
 *	wtcΥåϹԤʤ
 */
#define wtcchar(wtc) ((WTC)(wtc) & 0x0000ffff)
#define wtclang(wtc) ((WTC)(wtc) >> 16)

#define	WTNULL		0	/* ʸü */

/*
 * TC ʸ󤫤 WTC ʸؤѴ
 *	src ʸ WTC ʸѴ dst سǼ롣
 *	TNULL ã뤫len ʸ(WTC ñ)ޤѴ롣
 *	len ʸޤѴȤϡWTNULL ϳǼʤ
 *	len < 0 ξ len ̵뤵롣
 *	Ѵ̤ʸ(WTC ñ)֤ͤ
 *	ʸˤ WTNULL ʬϴޤޤʤ
 *	dst = NULL ξѴ̤ϳǼʤͤʸ֤
 */
IMPORT W tctowtc( WTC *dst, const TC *src, W len );

/*
 * WTC ʸ󤫤 TC ʸؤѴ
 *	src ʸ TC ʸѴ dst سǼ롣
 *	WTNULL ã뤫len ʸ(TC ñ)ޤѴ롣
 *	len ʸޤѴȤϡTNULL ϳǼʤ
 *	len < 0 ξ len ̵뤵롣
 *	Ѵ̤ʸ(TC ñ)֤ͤ
 *	ʸˤ TNULL ʬϴޤޤʤ
 *	dst = NULL ξѴ̤ϳǼʤͤʸ֤
 */
IMPORT W wtctotc( TC *dst, const WTC *src, W len );

/*
 * ʸ
 *	ʸ s1  s2 Ӥ롣
 *	s1  s2 Ƭ飱ʸӤǽ԰פȤʤäʸ羮
 *	ӷ̤Ȥ֤롣
 *	s1 ޤ s2  WTNULL ˽в񤦤ޤӤ롣
 *	WTNULL ˽в񤦤ޤ s1  s2 ʸ󤬰פƤϡ WTNULL
 *	˽вäȽǤ롣
 *	ʸӤϡޤꥳ(WTC ξ16ӥå)Ӥ롣
 *	ꥳɤפƤϡʸ(WTC β16ӥå)Ӥ
 *	롣
 *	ꥳɤϡTLANG ͤˤäӤ롣
 *	ʸɤϡtc_chcmp() ˤäӤ롣
 *
 *		> 0 : s1 > s2
 *		= 0 : s1 = s2
 *		< 0 : s1 < s2
 *
 *	wtc_strncmp() ϡ len ʸ(WTC ñ)ޤӤ롣
 *	ʳϡwtc_strcmp() Ʊ
 */
IMPORT W wtc_strcmp( const WTC *s1, const WTC *s2 );
IMPORT W wtc_strncmp( const WTC *s1, const WTC *s2, W len );

/*
 * ʸϢ
 *	ʸ dst θ src ɲä롣
 *	dst  WTNULL ΰ֤ src ɲä졢ɬü WTNULL ղä롣
 *	ͤ dst ֤
 *
 *	wtc_strncat() ϡsrc ʸ len ʸ(WTC ñ)ޤϢ뤹롣
 *	ʳ wtc_strcat() Ʊ
 */
IMPORT WTC* wtc_strcat( WTC *dst, const WTC *src );
IMPORT WTC* wtc_strncat( WTC *dst, const WTC *src, W len );

/*
 * ʸʣ
 *	ʸ src  dst إԡ롣
 *	ͤ dst ֤
 *
 *	wtc_strncpy() ϡsrc ʸ len ʸ(WTC ñ)ޤǥԡ롣
 *	src  len ʸûϡdst λĤ len ʸãޤ
 *	WTNULL 롣
 */
IMPORT WTC* wtc_strcpy( WTC *dst, const WTC *src );
IMPORT WTC* wtc_strncpy( WTC *dst, const WTC *src, W len );

/*
 * ʸ
 *	src  len ʸ(WTC ñ)ޤ ch 롣
 *	ü WTNULL ղäʤ
 *	ͤ str ֤
 */
IMPORT WTC* wtc_strset( WTC *str, WTC ch, W len );

/*
 * ʸĹ
 *	str Ĺ(WTC ñ)롣
 *	WTNULL ʬʸ˴ޤʤ
 */
IMPORT W wtc_strlen( const WTC *str );

/*
 * ʸ󸡺
 *	str ʸ󤫤 (*str & mask) == ch ʸõ
 *	ʸü WTNULL ⸡оݤȤʤ롣
 *	wtc_strchr()  str Ƭ齪üظäõ
 *	wtc_strrchr()  str νüƬظäõ
 *	ǽ˸Ĥä֤֤ͤĤʤä NULL ֤
 */
IMPORT WTC* wtc_strchr( const WTC *str, WTC ch, WTC mask );
IMPORT WTC* wtc_strrchr( const WTC *str, WTC ch, WTC mask );

#ifdef __cplusplus
}
#endif
#endif
