#ifndef _BWCHAR_H_
#define	_BWCHAR_H_

#include <sys/types.h>

typedef struct {
	u_int8_t state;
	u_int8_t id;	/* not used */
	u_int8_t data1;	/* not used */
	u_int8_t lang;  /* (offset -0x21) */ /* not used */
	union {
		struct {
			u_int16_t data2;
			u_int16_t len;
		} s;
		struct {
			u_int32_t len;
		} l;
	} c;
} tcstate_t;

#define TC_CUR_MAX 2

extern size_t tcsrtowcs (wchar_t *dst, const void **src, size_t dstlen, size_t *srclen, tcstate_t *ps);
extern size_t wcsrtotcs (TC *dst, const wchar_t **src, size_t len, tcstate_t *ps);
extern int tcsinit (const tcstate_t *ps);

#endif /* _BWCHAR_H_ */
