#ifndef _SYS_SIGINFO_H_
#define	_SYS_SIGINFO_H_

union sigval {
	int	sival_int;	/* integer value */
	void	*sival_ptr;	/* pointer value */
};

/*
 * SIGCLD signal codes
 */

#define	CLD_EXITED	1	/* child has exited */
#define	CLD_KILLED	2	/* child was killed */
#define	CLD_DUMPED	3	/* child has coredumped */
#define	CLD_TRAPPED	4	/* traced child has stopped */
#define	CLD_STOPPED	5	/* child has stopped on signal */
#define	CLD_CONTINUED	6	/* stopped child has continued */
#define	NSIGCLD		6

/*
 * SIGPOLL signal codes
 */

#define	POLL_IN		1	/* input available */
#define	POLL_OUT	2	/* output possible */
#define	POLL_MSG	3	/* message available */
#define	POLL_ERR	4	/* I/O error */
#define	POLL_PRI	5	/* high priority input available */
#define	POLL_HUP	6	/* device disconnected */
#define	NSIGPOLL	6

typedef struct siginfo {

	int	si_signo;			/* signal from signal.h	*/
	int 	si_code;			/* code from above	*/
	int	si_errno;			/* error from errno.h	*/

	union {
		struct {			/* kill(), SIGCLD, siqqueue() */
			pid_t	_pid;		/* process ID		*/
			union {
				struct {
					uid_t	_uid;
					union sigval	_value;
				} _kill;
				struct {
					clock_t _utime;
					int	_status;
					clock_t _stime;
				} _cld;
			} _pdata;
		} _proc;

		struct {			/* SIGPOLL, SIGXFSZ	*/
		/* fd not currently available for SIGPOLL */
			int	_fd;		/* file descriptor	*/
			long	_band;
		} _file;
	} _data;
} siginfo_t;

#if 0
#define	si_pid		_data._proc._pid
#endif
#define	si_status	_data._proc._pdata._cld._status
#define	si_stime	_data._proc._pdata._cld._stime
#define	si_utime	_data._proc._pdata._cld._utime
#define	si_uid		_data._proc._pdata._kill._uid
#define	si_value	_data._proc._pdata._kill._value
#define	si_fd		_data._file._fd
#define	si_band		_data._file._band

#endif /* _SYS_SIGINFO_H_ */
