/*
	sym.c		gterm ܥơ֥
*/
#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <string.h>
#include <a.out.h>

#include "coff.h"
#include "gterm.h"

typedef	struct exec		A_HEAD;		/* for a.out	*/
typedef	struct	nlist		A_SYMTAB;	/* for a.out	*/

typedef struct	{
	unsigned int	val;
	char		nm[160];
} ENT;

static	ENT	*syment = 0;
static	int	nsyms = 0;

/*----------------------------------------------------------------------*/
int	compare(i, j)
int	*i, *j;
{
	return	*i - *j;
}
/*----------------------------------------------------------------------*/
/*	a.out μ¹ԥե뤫饷ܥɤ				*/

int	symload_aout(fp, fn, base, ah)
FILE	*fp;
char	*fn;
unsigned int base;
A_HEAD	*ah;
{
	int		i, n, c;
	A_SYMTAB	ast;
	long		pos;
	ENT		*ep;

	if (ah->a_syms == 0) {
		Print("%s : already stripped\n", fn); return 0;
	}

	if (base) base -= ah->a_entry;

	if (n = ah->a_syms / sizeof(A_SYMTAB)) {

		if (!(syment = (ENT *)calloc(sizeof(ENT), n))) {
			Print("can't alloc memory"); return -1;
		}
		ep = syment;

		if (fseek(fp, N_SYMOFF(*ah), 0)) {
			Print("%s : file seek error", fn); return -1;
		}

		while (n--) {
			if (fread(&ast, sizeof(A_SYMTAB), 1, fp) != 1) {
				Print("%s: can't read\n", fn); return -1;
			}

			i = ast.n_type & N_TYPE;
			if (i != N_ABS && i != N_TEXT && i != N_DATA &&
			    i != N_BSS 
#ifdef N_COMM
			    && i != N_COMM
#endif
			    ) continue;
			if ((ast.n_type & N_EXT) == 0) continue;

			ep[nsyms].val = ast.n_value + base;

			pos = ftell(fp);

			fseek(fp, N_STROFF(*ah) + ast.n_un.n_strx, 0);

			for (i = 0; (c = getc(fp)) != EOF; i++) {
				if ((ep[nsyms].nm[i] = c) == 0) break;
			}
			ep[nsyms].nm[i] = 0;
			fseek(fp, pos, 0);
			nsyms++;
		}
		qsort (ep, nsyms, sizeof(ENT), compare);
	}

	Print ("SYMT : %s (a.out) [%#x ==> %#x] %d symbols)\n",
			fn, ah->a_entry, base + ah->a_entry, nsyms);
	return 0;
}
/*----------------------------------------------------------------------*/
/*	[fn].map Υƥȥե뤫饷ܥɤ			*/

#define	MAXSYMS		10000

int	symload_map(fp, fn, base)
FILE	*fp;
char	*fn;
unsigned int base;
{
	char	buf[512];
	char	type;
	ENT	*ep;
	int	len;

	if (!(syment = (ENT*)calloc(sizeof(ENT), MAXSYMS))) {
		Print("can't alloc memory"); return -1;
	}
	ep = syment;

	while (fgets(buf, 512, fp) != NULL) {
		if ((len = strlen(buf)) < 12) continue;
		if (buf[len-1] == '\n') buf[len-1] = '\0';
		type = buf[9];
		if (type != 'B' && type != 'D' && type != 'T') continue;
		sscanf(buf, "%08x", &ep->val);
		ep->val += base;
		strcpy(ep->nm, &buf[11]);
		ep++;
		nsyms++;
		if (nsyms++ > MAXSYMS) {
			Print("too many symbols\n");
			break;
		}
	}
	qsort(syment, nsyms, sizeof(ENT), compare);

	Print ("SYMT : %s (map) %d symbols)\n", fn, nsyms);

	return 0;
}
/*----------------------------------------------------------------------*/
void	symload(fn, p)
char	*fn, *p;
{
	int		er, aout_flg;
	unsigned int	base;
	FILE		*fp;
	A_HEAD		ahead;
	char		fname[512], *cp;

	aout_flg = 0;
	if ((fp = fopen(fn, "r")) &&
		fread(&ahead, sizeof(A_HEAD), 1, fp) == 1 &&
		! N_BADMAG(ahead)) aout_flg++;

	if (aout_flg == 0) {
		if (fp) fclose(fp);
		if ((cp = (char*)strrchr(fn, '.')) == NULL) {
			strcpy(fname, fn);
			strcat(fname, ".map");
			fn = fname;
		} else if (strcmp(cp, ".map") != 0) {
			Print("%s : not a.out or .map file\n", fn);
			return;
		}
		if ((fp = fopen(fn, "r")) == NULL) {
			Print("%s : can't open\n", fn);
			return;
		}
	}
	if (syment) {
		free(syment);
		syment = (ENT*)0;
	}
	nsyms = 0;

	base = (*p) ? strtol(p, 0, 16) : 0;

	if (aout_flg) {
		er = symload_aout(fp, fn, base, &ahead);
	} else {
		er = symload_map(fp, fn, base);
	}
	if (er < 0) {
		if (syment) free(syment);
		syment = (ENT*)0;
		nsyms = 0;
	}
	fclose(fp);
}
/*----------------------------------------------------------------------*/
int	str_cmp (line, nm, len)
char	*line, *nm;
int	len;
{
	int	n = strlen (line) - len;
	while (n-- >= 0) {
		if (memcmp (line, nm, len) == 0) return 1;
		line++;
	}
	return 0;
}
/*----------------------------------------------------------------------*/
void	symeval(sym, p)
char	*sym, *p;
{
	char	c;
	int	i, k;
	ENT	*ep;
	unsigned int	n;

	if (! syment || ! nsyms) return;

	if (isdigit(sym[0])) {
		n = strtol (sym, 0, 16);
		for (ep = syment, i = 0; i < nsyms; i++, ep++) {
			if (n < ep->val) break;
		}
		if (i) --ep;
		Print ("%08x : %s + %x\n", n, ep->nm, n - ep->val);

	} else if (sym[0] == '?') {
		n = strtol (&sym[1], 0, 16);
		for (ep = syment, i = 0; i < nsyms; i++, ep++) {
			if (n < ep->val) break;
		}
		for(k = 0; k < nsyms - i; ep++) {
			Print ("%08x : %s\n", ep->val, ep->nm);
			if ((++k) % 32 == 0) {
				Print ("*** more (y/n) ?");
				while ((c = TYin()) == 0);
				Print("\n");
				if (c != 'y' && c != 'Y') break;
			}
		}

	} else if (n = strlen (sym)) {
		for (ep = syment, i = 0; i < nsyms; i++, ep++)
			if (str_cmp (ep->nm, sym, n))
				Print ("%08x: %s\n", ep->val, ep->nm);
	}
}
