/*
	gterm.c		gterm	ᥤ
*/
#include	<stdio.h>
#include	<setjmp.h>
#include	<signal.h>
#include	<ctype.h>
#include	<stdlib.h>
#include	<string.h>
#include	<memory.h>
#include	<stdarg.h>

#include	"devio.h"

#include	"gterm.h"

#define	START_MSG	"<< Gterm ver 2.03 : 970619 >>\n"
#define	END_MSG		"\n<< exit Gterm >>\n"

#define	ESC	0x1b
#define	BS	0x08
#define	TAB	0x09
#define	CR	0x0d
#define	LF	0x0a

#ifdef	DOS
#define	MAX_NEST	4
#define	MAX_HIST	6
#define	MAX_DEFS	(6*1024)
#define	MAX_ALIASES	(6*1024)
#else
#define	MAX_NEST	32
#define	MAX_HIST	50
#define	MAX_DEFS	(32*1024)
#define	MAX_ALIASES	(16*1024)
#endif
#define	LINE_LEN	2048

#define	DEFLOGFN	"gterm.log"

FILE	*logfp = NULL;

uchar	linebuf[LINE_LEN], *curp, *endp;
char	lbuf[LINE_LEN], llbuf[LINE_LEN];
uchar	last[4] = {0, 0, 0, 0};
#define	MAX_PROMPT	12
char	*prompt[MAX_PROMPT] = {			/* ʸ */
		"> \0\0\0\0\0\0",		/* 1 */
		"% \0\0\0\0\0\0",		/* 2 */
		"? \0\0\0\0\0\0\0",		/* 3 */
		"\0\0\0\0\0\0\0\0",		/* 4 */
		"\0\0\0\0\0\0\0\0",		/* 5 */
		"\0\0\0\0\0\0\0\0",		/* 6 */
		"\0\0\0\0\0\0\0\0",		/* 7 */
		"\0\0\0\0\0\0\0\0",		/* 8 */
		"\0\0\0\0\0\0\0\0",		/* 9 */
		"\0\0\0\0\0\0\0\0",		/* 10 */
		"\0\0\0\0\0\0\0\0",		/* 11 */
		"\0\0\0\0\0\0\0\0"};		/* 12 */

FILE	*fp;

#define	XDBG_PR	']'
#define	XDBG	100

FILE	*infp[MAX_NEST];
uchar	*args[MAX_NEST];
int	nest = 0;
int	mode = 0;
int	expand = 0;
int	LFflg = 0;
int	repcnt[MAX_NEST];
uchar	*repbuf;

uchar	cmd_ch = '.';

int	wait_flg = 0;
int	do_break = 0;
int	cons_off = 0;
int	baud = 14;		/* 19200 */

int	OUT_WAIT = 0;
int	IN_WAIT = 0;
int	CR_OUT = 1;

jmp_buf	int_jump;

#define	HIST_SZ		(MAX_HIST*LINE_LEN)
uchar	*hist;
int	hcnt = MAX_HIST;

#define	CMD_NONE	0
#define	CMD_QUIT	1
#define	CMD_CD		2
#define	CMD_PWD		3
#define	CMD_TON		4
#define	CMD_TOFF	5
#define	CMD_WAIT	6
#define	CMD_ALIAS	7
#define	CMD_UNALIAS	8
#define	CMD_DEF		9
#define	CMD_UNDEF	10
#define	CMD_ESC		11
#define	CMD_DO		12
#define	CMD_SH		13
#define	CMD_HELP	14
#define	CMD_PROM	15
#define	CMD_REPT	16
#define	CMD_CMNT	17
#define	CMD_PRINT	18
#define	CMD_INPUT	19
#define	CMD_BREAK	20
#define	CMD_CONT	21
#define	CMD_HIST	22
#define	CMD_CON		23
#define	CMD_COFF	24
#define	CMD_SYMT	25
#define	CMD_EVAL	26
#define	CMD_LOAD	27
#define	CMD_TLOAD	28
#define	CMD_MLOAD	29
#define	CMD_LOADM	30
#define	CMD_LOADX	31

#define	CMD_OUTWAIT	50
#define	CMD_INWAIT	51
#define	CMD_CROUT	60

typedef	struct {
	int	id;
	char	*str;
} CMD;

CMD	command[] = {
	{CMD_QUIT,	"q"},
	{CMD_CD,	"cd"},
	{CMD_PWD,	"pwd"},
	{CMD_TON,	"ton"},
	{CMD_TOFF,	"toff"},
	{CMD_WAIT,	"wait"},
	{CMD_ALIAS,	"alias"},
	{CMD_UNALIAS,	"unalias"},
	{CMD_DEF,	"def"},
	{CMD_UNDEF,	"undef"},
	{CMD_ESC,	"esc"},
	{CMD_DO,	"do"},
	{CMD_SH,	"!"},
	{CMD_HELP,	"?"},
	{CMD_PROM,	"prompt"},
	{CMD_REPT,	"#"},
	{CMD_CMNT,	"*"},
	{CMD_PRINT,	"pr"},
	{CMD_INPUT,	"?def"},
	{CMD_BREAK,	"break"},
	{CMD_CONT,	"cont"},
	{CMD_LOAD,	"load"},
	{CMD_LOADM,	"loadm"},
	{CMD_LOADX,	"loadx"},
	{CMD_TLOAD,	"tload"},
	{CMD_MLOAD,	"MLOAD"},
	{CMD_HIST,	"hist"},
	{CMD_CON,	"con"},
	{CMD_COFF,	"cof"},
	{CMD_SYMT,	"symt"},
	{CMD_EVAL,	"@"},
	{CMD_OUTWAIT,	"OUTWAIT"},
	{CMD_INWAIT,	"INWAIT"},
	{CMD_CROUT,	"CROUT"},
	{CMD_NONE,	NULL} };

char	*help_message[] = {
	"	.esc c			.prompt n 'c..c'	\n",
	"	.cd [dir]		.pwd			\n",
	"	.ton [fn]		.toff			\n",
	"	.alias [cmd str]	.unalias cmd | ALL	\n",
	"	.def id replaced_id	.undef id | ALL		\n",
	"	.pr [str]		.?def id ...		\n",
	"	.do fn			.wait n			\n",
	"	.break			.cont			\n",
	"	.! [sh_cmd]		.# rep_cnt cmd		\n",
	"	.* [comment]		.?			\n",
	"	.load fn [addr]					\n",
	"	.hist			.q			\n",
	"	.con			.cof			\n",
	"	.symt a.out_file adr	.@ sym | adr | ? |?adr  \n",
	NULL};

uchar	*def_top, *def_end;

uchar	*alias_top, *alias_end;

#define	LFOUT	{Putc(LF);LFflg++;}


/*----------------------------------------------------------------------*/
void	Putc(uchar c)
/*----------------------------------------------------------------------*/
{
	TYout(c);
	if (c != CR && logfp) fputc(c, logfp);
}
/*----------------------------------------------------------------------*/
void	Puts(uchar *s)
/*----------------------------------------------------------------------*/
{
	uchar	c;

	TYouts(s);
	if (logfp)
		while ((c = *s++) != 0) {
			if (c != CR) fputc(c, logfp);
		}
}
/*----------------------------------------------------------------------*/
void	Print(char *fmt, ...)
/*----------------------------------------------------------------------*/
{
	va_list	ap;
	char	buf[LINE_LEN];

	va_start(ap, fmt);
	vsprintf(buf, fmt, ap);
	va_end(ap);
	Puts(buf);
}
/*----------------------------------------------------------------------*/
int	Getc(int f)
/*----------------------------------------------------------------------*/
{
	int	c;

	for (;;) {
		if (nest == 0 || f) return TYin();
		if (wait_flg) return (0);
		if ((c = getc(infp[nest-1])) != EOF) return c;
		fclose (infp[nest-1]);
		wait_flg = do_break = 0;
		if (--nest == 0) {
		    if ((c = TYin()) == 0 && last[2] == 0) show_prompt();
		    return (c);
		}
	}
}
/*----------------------------------------------------------------------*/
void	show_prompt()
/*----------------------------------------------------------------------*/
{
	if (mode) {
		if (mode == XDBG) Putc(XDBG_PR);
		else Puts(prompt[mode - 1]);
	}
}
/*----------------------------------------------------------------------*/
int	RSgetc(int f)
/*----------------------------------------------------------------------*/
{
	int	c;
	if (nest == 0 && repcnt[0] == 0) {if (PollRSTY() && f) TYin();}
	c = RSin();
	if (logfp) fprintf(logfp, "%02x ", c & 0xff);
	return c;
}
/*----------------------------------------------------------------------*/
void	RSputc(uchar c)
/*----------------------------------------------------------------------*/
{
	RSout(c);
	if (OUT_WAIT > 0) sleep_ms(OUT_WAIT);
}
/*----------------------------------------------------------------------*/
void	RSputs(uchar *s)
/*----------------------------------------------------------------------*/
{
	while (*s) RSputc(*s++);
	if (CR_OUT) RSout(CR);		/** ̣ƤǤϤʤ  **/
	while (RSgetc(1) != CR);	/* ignore echo */
}
/*----------------------------------------------------------------------*/
int	getline(int f)
/*----------------------------------------------------------------------*/
{
	uchar	*p;
	int	c;
	int	rep = 0;

	if (f == 0 && repcnt[nest]) {
	    rep++;
	    strcpy (linebuf, &repbuf[LINE_LEN * nest]);
	    repcnt[nest]--;
	    endp = curp = linebuf + strlen (linebuf);
	} else

	while ( (c = Getc(f)) != LF && c != CR) {
	    if (c < 0 || (f == 0 && c == 0)) return(0);
	    switch (Keytest(c)) {
		case 'A'-'@':
		    while (curp > linebuf) {cur_bwd(); curp--;}
		    break;
		case 'E'-'@':
		    while (curp < endp) {cur_fwd(); curp++;}
		    break;
		case 'P'-'@':
		case CUR_UP:	c = 0;
		case 'N'-'@':
		case CUR_DWN:
		    if (c)  {if (++hcnt >= MAX_HIST) hcnt = MAX_HIST - 1;}
		    else    {if (--hcnt < 0) hcnt = 0;}
		    memcpy (linebuf, hist + (hcnt * LINE_LEN), LINE_LEN);
		    line_erase();
		    while (curp > linebuf) {cur_bs(); curp--;}
		    while (*curp) TYout(*curp++); TYflush();
		    endp = curp;
		    break;
		case LINE_ERASE:
		    line_erase();
		    endp = curp;
		    break;
		case BS:
		case DEL:
		    if (curp > linebuf) {
			cur_bs();
			if (curp < endp) memcpy (curp - 1, curp, endp - curp);
			endp--;
			curp--;
		    }
		    break;
		case 'D'-'@':
		    if (curp >= linebuf) {
			cur_del();
			if (curp < endp) {
			    memcpy (curp, curp + 1, endp - curp);
			    endp--;
			}
		    }
		    break;
		case 'X'-'@':
		case CANCEL:
		    line_erase();
		    while (curp > linebuf) {cur_bs(); curp--;}
		    endp = curp;
		    break;
		case 'F'-'@':
		case CUR_FWD:
		    if (curp < endp) {cur_fwd(); curp++;}
		    break;
		case 'B'-'@':
		case CUR_BWD:
		    if (curp > linebuf) {cur_bwd(); curp--;}
		    break;
		default:
		    if (c < ' ' && c != TAB) continue;
		    if (curp < endp) {
#if 0
			memmove(curp+1, curp, endp - curp);
#else
			{uchar *cp;
			for (cp = endp; --cp >= curp;) *(cp+1) = *cp;
			}
#endif
			cur_end();
		    }
		    *curp++ = c;
		    endp++;
		    if (!nest || expand || f) TYout(c);
	    }
	    TYflush();
	}
	*endp = 0;

	if (*linebuf) {
	    if (nest == 0 && rep == 0) {
		if (linebuf[0] != '!') {
		    if (f == 0) {
			memcpy (hist, hist+LINE_LEN, HIST_SZ - LINE_LEN);
			memcpy (hist + HIST_SZ - LINE_LEN, linebuf, LINE_LEN);
		    }
		    if (logfp) fputs(linebuf, logfp);
		}
	    } else if (expand && logfp) fputs(linebuf, logfp);
	}
	hcnt = MAX_HIST;
	if (!nest || expand || f) LFOUT;
	return (1);
}
/*----------------------------------------------------------------------*/
uchar	* linein(uchar *s)
/*----------------------------------------------------------------------*/
{
	if (s) Puts(s);
	endp = curp = linebuf;
	if (getline(1) == 0) return NULL;
	endp = curp = linebuf;
	return (curp);
}
/*----------------------------------------------------------------------*/
void	finish()
/*----------------------------------------------------------------------*/
{
	sys_end(0);
}
/*----------------------------------------------------------------------*/
void	restart()
/*----------------------------------------------------------------------*/
{
	TYreinit();
}
/*----------------------------------------------------------------------*/
void	int_break()
/*----------------------------------------------------------------------*/
{
	longjmp(int_jump, 1);
}
/*----------------------------------------------------------------------*/
FILE * f_open(uchar *path, uchar *mode)
/*----------------------------------------------------------------------*/
{
	register uchar	c;
	uchar	buf[LINE_LEN];
	uchar	*p;
	uchar	*bp = buf;

	while (c = *path++) {
	    if (c == '~' && (p = getenv("HOME"))) {
		strcpy (bp, p);
		bp += strlen(bp);
	    } else *bp++ = c;
	}
	*bp = 0;
	return fopen(buf, mode);
}
/*======================================================================*/
main(ac, av)
/*======================================================================*/
int	ac;
uchar	**av;
{
	uchar	c, c1, *ln, *p;
	int	i, j, quit, xinterrupt;
	int	idle;
	int	loadmode, loadmem;
	uchar	loadpath[LINE_LEN];

	alias_end = alias_top = calloc(MAX_ALIASES, 1);
	def_end = def_top = calloc(MAX_DEFS, 1);
	hist = calloc (MAX_HIST, LINE_LEN);
	repbuf = calloc (MAX_NEST, LINE_LEN);

	ln = NULL;
	fp = NULL;

	while ((p = *++av) && *p == '-') {
		switch (*++p) {
		case 'c':
		case 'C':	if (!(fp = f_open(++p, "r")))
				fprintf (stderr, "..  Can't open: %s\n", p);
				break;
		case '3':	baud = 15 ;	/* 38400 */
				break;
		case '1':	baud = 14 ;	/* 19200 */
				break;
		case '9':	baud = 13 ;	/* 9600 */
				break;
		case '4':	baud = 12 ;	/* 4800 */
				break;
		case '2':	baud = 11 ;	/* 2400 */
				break;
		case 'l':
		case 'L':	ln = ++p;	break;
		default:
			fprintf (stderr, ".. Illegal option: %s\n", *av);
			sys_end(0);
		}
	}

	if (!fp) {
		p = getenv("GTERM");
		if (!(fp = f_open (p? p : (uchar *)".gterm", "r")))
			fp = f_open ((uchar *)"~/.gterm", "r");
	}
	if (fp) {infp[0] = fp; nest = 1;}

	if (TYinit())
		{fprintf (stderr, ".. TTY INIT error\n"); sys_end(1);}

	if (RSinit (ln, baud)) {TYouts (".. RS INIT error\n"); sys_end(1);}

	for (i = 0; i < MAX_NEST; i++) {
		if (!(args[i] = calloc(LINE_LEN, 1)))
			{TYouts(".. Can't allocate memory\n"); sys_end(1);}
	}

	if (nest) {
		ln = args[0];
		while (p = *av++) {
			strcpy (ln, p);
			ln += strlen (ln);
			*ln++ = ' ';
		}
		*ln = 0;
	}

	TYouts(START_MSG);

#ifndef	DOS
	signal(SIGHUP, finish);
	signal(SIGQUIT, finish);
	signal(SIGTERM, finish);
	signal(SIGCONT, restart);
#endif

	loadmode = 0;
	mode = 1;
	quit = 0;
	def_end = def_top;
	alias_end = alias_top;
	*linebuf = 0;
	endp = curp = linebuf;

	xinterrupt = 0;
	if (setjmp(int_jump)) {
		while (nest) fclose(infp[--nest]);
		wait_flg = do_break = cons_off = 0;
		Puts("^C");
		RSputc('C'-'@');
		show_prompt();
		xinterrupt++;
	}
#ifndef	DOS
	signal(SIGINT, int_break);
#endif

	idle = 0;
    do {
	TYflush();
	while ((i = RSgetc(0)) > 0) {
		c = i;
		if (c == 'S'-'@' || c == 'Q'-'@') continue;
		if (c == 0x10) {  /* DLE */
			loadmode = 1;
			continue;
		}
		if (loadmode) {
			if (loadmode == 1) {
				if (c != 'S' && c != 's') loadmode = 0;
				else {
					loadmode = 2;
					loadmem = (c == 's') ? -1 : 0;
				}
				continue;
			}
			if (c == '\n') {
				loadpath[loadmode - 2] = 0;
				loadmode = 0;
#ifdef USE_LOADCMD
				do_load(1, loadmem, -1, loadpath);
#endif /* USE_LOADCMD */
				last[2] = mode = 0;
				LFOUT;
				TYflush();
			} else if (c > ' ') {
				loadpath[loadmode++ - 2] = c;
			}
			continue;
		}

		mode = 0;
		last[0] = last[1];
		last[1] = last[2];
		last[2] = c;

		if (c == ESC) {
			while ((c = RSin()) <= 0);
			switch(c & 0x7f) {
			case 'A':	cur_up();	break;
			case 'B':	cur_dwn();	break;
			case 'C':	cur_fwd();	break;
			case 'D':	cur_bwd();	break;
			case 'H':	cur_home();	break;
			case 'Y':	while ((c = RSin()) <= 0);
					while ((c1 = RSin()) <= 0);
					cur_addr(c-' ', c1-' '); break;
			case 'E':	scrn_clr();	break;
			case 'J':	scrn_erase();	break;
			case 'K':	scrn_erase();	break;
			case 'X':	delm_on();	break;
			case 'W':	delm_off();	break;
			case 'R':	rev_on();	break;
			case 'O':	rev_off();	break;
			}
		} else if (c == BS) {
			cur_bs();
		} else {
			if (c < ' ' && (c != LF && c != CR && c != TAB))
					{Putc('^'); c += '@';}
			if (!cons_off && (!LFflg || c != LF)) Putc(c);
		}
		LFflg = 0;
		idle = 0;
	}

	if (idle < IN_WAIT) {
		idle++;
		sleep_ms(10);
		continue;
	}
	TYflush();

	if (xinterrupt && mode == 0) {
		show_prompt();
		mode = 1;
	}

	if (mode == 0) {
		endp = curp = linebuf;
		for (i = 0; i < MAX_PROMPT; i++) {
			if ((j = strlen (prompt[i])) &&
				strcmp(prompt[i] + (j > 3 ? j - 3 : 0),
				&last[j > 3 ? 0 : 3 - j]) == 0) {
				mode = i + 1;
				break;
			}
		}
		if (mode == 0 && last[0] == CR && last[1] == LF &&
					last[2] == XDBG_PR) mode = XDBG;
	}

	if (mode) {
		loadmode = 0;
LOOP:
		if (getline(do_break)) {
			xinterrupt = 0;
			endp = curp = linebuf;
			if (mode == XDBG) {
				last[2] = 0;
				if (linebuf[0] != cmd_ch ||
					(quit = do_cmd(linebuf)) == 0) {
					if (DoDebug(linebuf)) {
						Putc(XDBG_PR);
						endp = curp = linebuf;
						goto LOOP;
					}
					last[2] = mode = 0;
				}
			} else {
				if (alias_line(lbuf, linebuf)) goto LOOP;
				args_line(llbuf, lbuf);
				make_line(lbuf, llbuf, 1);
				last[2] = 0;
				if (lbuf[0] != cmd_ch ||
					(quit = do_cmd(lbuf)) == 0) {
					make_line(lbuf, llbuf, 0);
					RSputs(lbuf);
					last[2] = mode = 0;
				}
			}
		}

	} else while (c = TYin()) {
		if (c == DEL) c = BS;
		else if (c == BS) c = DEL;
		else if (c == LF) c = CR;
		else if (c < ' ') {
			switch (Keytest(c)) {
			case CUR_UP:	c = 'A';	break;
			case CUR_DWN:	c = 'B';	break;
			case CUR_FWD:	c = 'C';	break;
			case CUR_BWD:	c = 'D';	break;
			case CUR_UPx:	c = 'K'-'@';	break;
			case CUR_DWNx:	c = 'J'-'@';	break;
			case CUR_FWDx:	c = 'L'-'@';	break;
			case CUR_BWDx:	c = 'H'-'@';	break;
			case CANCEL:	c = 'U'-'@';	break;
			case SCRN_CLR:	c = 'E';	break;
			case LINE_ERASE:c = 'K';	break;
			}
			if (c > ' ') {
				RSputc(ESC); sleep_ms(80);
				RSputc(c); sleep_ms(80);
				c = 0;
			}
		}
		if (c) RSputc(c);
	}
    } while (quit >= 0);

	TYouts(END_MSG);
	sys_end(0);
}
/*----------------------------------------------------------------------*/
uchar	*skipsp(uchar *p)
/*----------------------------------------------------------------------*/
{
	while (*p && *p <= ' ') p++;
	return p;
}
/*----------------------------------------------------------------------*/
uchar	*skipdelm(uchar *p)
/*----------------------------------------------------------------------*/
{
	while ((*p && *p <= ' ') || *p == ',' || *p == '.') p++;
	return p;
}
/*----------------------------------------------------------------------*/
void	get_term(uchar *buf, uchar **pp)
/*----------------------------------------------------------------------*/
{
	uchar	*p;

	p = skipsp(*pp);
	while ((*buf = *p) > ' ') { buf++; p++;}
	*buf = 0;
	*pp = skipsp(p);
}
/*----------------------------------------------------------------------*/
int	get_id(uchar *buf, uchar **pp)
/*----------------------------------------------------------------------*/
{
	uchar	c, *p;
	int	n;

static char idchar[] = {
   /*	0  1  2  3  4  5  6  7	8  9  a  b  c  d  e  f	*/
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,		/*  0- F */
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,		/* 10-1F */
	0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0,		/* 20-2F */
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0,		/* 30-3F */
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,		/* 40-4F */
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 2, 0, 0, 1,		/* 50-5F */
	0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,		/* 60-6F */
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 1, 0		/* 70-7F */
};
#define	is_sid(c)	((c)>=0x80||idchar[c])
#define	is_id(c)	((c)>=0x80||(idchar[c]&1))

	for (n = 0, p = *pp; c = *p; p++) {
		if (is_sid(c)) {
			if (c == '$') while (*(p+1) == '{') {p++; n++;}
			do {*buf++ = c; n++; c = *++p;}
			while (is_id(c));
			break;
		}
	}
	*buf = 0;
	*pp = p;
	return	n;
}
/*----------------------------------------------------------------------*/
uchar	*out_def(uchar *p)
/*----------------------------------------------------------------------*/
{
	uchar	*q;

	q = p + strlen(p) + 1;
	Print (".. %s : %s\n", p, q);
	return (q + strlen(q) + 1);
}
/*----------------------------------------------------------------------*/
int	more()
/*----------------------------------------------------------------------*/
{
	uchar	c;

	Puts(".. (more) ? ");
	while ((c = TYin()) == 0);
	LFOUT;
	return (c != 'y' && c != 'Y')? 1 : 0;
}
/*----------------------------------------------------------------------*/
void	list_def(int alias)
/*----------------------------------------------------------------------*/
{
	uchar	*p, *top, *end;
	int		cnt;

	top = (alias)? alias_top : def_top;
	end = (alias)? alias_end : def_end;

	cnt = 10;
	for (p = top; p < end;) {
	    if (--cnt <= 0) {
		if (more()) break;
		cnt = 10;
	    }
	    p = out_def(p);
	}
}
/*----------------------------------------------------------------------*/
void	reset_def(int alias)
/*----------------------------------------------------------------------*/
{
	if (alias) alias_end = alias_top;
	else	   {def_end = def_top;	expand = 0; }
}
/*----------------------------------------------------------------------*/
void	put_def(int alias, uchar *buf, uchar *p)
/*----------------------------------------------------------------------*/
{
	int	i, j;
	uchar	*end;

	end = (alias)? alias_end : def_end;

	if ((i = strlen(buf)) + (j = strlen(p)) + 2 + end
		>= (alias? (alias_top + MAX_ALIASES) : (def_top + MAX_DEFS))) {
		Puts ((alias)? ".. Too many aliases\n" :
				   ".. Too many defines\n");
	} else {
		strcpy (end, buf);
		end += i + 1;
		strcpy (end, p);
		end += j + 1;
		if (alias) alias_end = end;
		else {
			def_end = end;
			if (strcmp("EXPAND", buf) == 0) expand = 1;
		}
	}
}
/*----------------------------------------------------------------------*/
void	rem_def(int alias, uchar *p)
/*----------------------------------------------------------------------*/
{
	int	i;
	uchar	*pp;

	if (!alias && strcmp("EXPAND", p) == 0) expand = 0;

	pp = p + strlen(p) + 1;
	pp += strlen(pp) + 1;

	if (i = ((alias)? alias_end : def_end) - pp) memcpy (p, pp, i);

	if (alias) alias_end = p + i;
	else	   def_end = p + i;
}
/*----------------------------------------------------------------------*/
uchar* find_def(int alias, uchar *buf)
/*----------------------------------------------------------------------*/
{
	uchar	*p;
	uchar	*end;

	p = (alias)? alias_top : def_top;
	end = (alias)? alias_end : def_end;

	for (; p < end && (*p != *buf || strcmp (buf, p));) {
		p += strlen(p) + 1;
		p += strlen(p) + 1;
	}
	if (p < end) return p;
	else	return NULL;
}
/*----------------------------------------------------------------------*/
int	alias_line(uchar *d, uchar *s)
/*----------------------------------------------------------------------*/
{
	uchar		buf[LINE_LEN], sbuf[LINE_LEN];
	uchar		*p, *pp, *ss, *sx, *dd;
	int		n, loop;

	loop = 0;
	dd = d;
AGAIN:
	ss = s;
	get_term(buf, &s);

	if (p = find_def(1, buf)) {
	    p += strlen (p) + 1;
	    sx = s;

	    while (*p) {
		pp = p;
		n = get_id (buf, &p);
		strncpy (d, pp, p - pp);
		d += p - pp;
		if (buf[0]=='$' && buf[2]==0 && buf[1]>='1' && buf[1]<='9') {
		    d -= n;
		    for (ss = s, n = buf[1] - '0'; --n >= 0;) get_term(d, &ss);
		    if (ss > sx) sx = ss;
		    d += strlen(d);
		}
	    }
	    *d++ = ' ';
	    strcpy (d, sx);
	    if (++loop <= 16) {
		strcpy (s = sbuf, d = dd);
		goto AGAIN;
	    }
	} else strcpy (d, ss);

	d += strlen(d);
	while (*--d <= ' ');
	*++d = 0;

	n = d - dd;
	if (*dd == '!') {
	    p = hist + HIST_SZ - LINE_LEN;
	    if (--n > 0) {
		while (p >= hist && strncmp(p, dd + 1, n)) p -= LINE_LEN;
	    }
	    if (p >= hist) strcpy (linebuf, p);
	    else	   linebuf[0] = 0;
	    line_erase();
	    Puts("= ");
	    while (curp > linebuf) {cur_bs(); curp--;}
	    while (*curp) TYout(*curp++); TYflush();
	    endp = curp;
	    *dd = 0;
	    return 1;
	}

	n = 0;

	/* check if multi-line ";;" */
	for (d = dd; *d; d++) {
	    if (*d == '\\') {
		if (*++d == 0) break;
	    } else if (*d == ';' && *(d+1) == ';') {
		strcpy (d, d+1);
		*d = '\n';
		n++;
	    }
	}
	if (n) {
	    if (nest >= MAX_NEST) {
		Puts(".. Too many nest\n");
		n = 0;
	    } else if (!(fp = tmpfile ())) {
		Puts(".. Can't open tmpfile \n");
		n = 0;
	    } else {
		strcat(dd, "\n");
		fwrite (dd, strlen (dd), 1, fp);
		rewind (fp);
		infp[nest] = fp;
		*(args[nest++]) = 0;
	    }
	    *dd = 0;
	}
	return n;
}
/*----------------------------------------------------------------------*/
void	args_line(uchar *d, uchar *s)
/*----------------------------------------------------------------------*/
{
	int	n;
	uchar	*p, *dd, *ss;
	uchar	buf[LINE_LEN];

	dd = d;
	if (nest) {
	    while (*s) {
		ss = s;
		n = get_id (buf, &s);
		strncpy (d, ss, s - ss);
		d += s - ss;
		if (buf[0] == '$' && buf[2] == 0 &&
				buf[1] >= '1' && buf[1] <= '9') {
		    d -= n;
		    p = args[nest-1];
		    for (n = buf[1] - '0'; --n >= 0;) get_term (d, &p);
		    d += strlen(d);
		}
	    }
	    *d = 0;
	} else {
	    strcpy (d, s);
	}
}
/*----------------------------------------------------------------------*/
void	make_line(uchar *d, uchar *s, int flg)
/*----------------------------------------------------------------------*/
{
	uchar	buf[LINE_LEN], sbuf[LINE_LEN];
	uchar	c, *ss, *p, *dd;
	int	n, exp, loop;

	dd = d;
	loop = 0;
AGAIN:
	exp = 0;
	while (*s) {
		ss = s;
		n = get_id (buf, &s);
		strncpy (d, ss, s - ss);
		d += s - ss;
		if (flg && (n < 2 || buf[0] != '$')) n = 0;
		if (n && (p = find_def(0, buf + (buf[0]=='$' ? 1 : 0)))) {
			strcpy (d -= n, p + strlen (p) + 1);
			d += strlen(d);
			exp++;
		}
	}
	*d = 0;
	if (exp && (++loop) <= 16) {
		strcpy (s = sbuf, d = dd);
		goto AGAIN;
	}

	/* remove \ { }  convert  ^X ==> X-'@' */

	for (; c = *dd; dd++) {
	    if (c == '\\') {
		strcpy (dd, dd+1);
		if (*dd == 0) break;
	    } else if (c == '{' || c == '}') {
		strcpy (dd, dd+1);
		dd--;
	    } else if (c == '^' && (c = *(dd+1) - '@') < ' ') {
		strcpy (dd, dd+1);
		*dd-- = c;
	    }
	}
}
/*----------------------------------------------------------------------*/
void	time_out()
/*----------------------------------------------------------------------*/
{
	wait_flg = 0;
}
/*----------------------------------------------------------------------*/
int	do_cmd(uchar *p)
/*----------------------------------------------------------------------*/
{
	int	er = 0;
	int	i;
	uchar	buf[LINE_LEN];
	uchar	*q, *qq;
	uchar	**pp;
	CMD	*cmd;

	++p;
	get_term (buf, &p);
	if (buf[0] == '*') goto NEXT;

	for (cmd = command; cmd->id && strcmp (cmd->str, buf); cmd++);

	switch (cmd->id) {
	case CMD_NONE:	return 0;
	case CMD_QUIT:	return -1;
	case CMD_ESC:	if (*p) cmd_ch = *p;
			else	Print (".. Esc ch: %c\n", cmd_ch);
			break;
	case CMD_CD:	if (*p) {
			    get_term (buf, &p);
			    if (er = chdir ((buf[0])? buf : NULL)) break;
			}
	case CMD_PWD:	if (getcwd (buf, 256) == NULL) er = 1;
			else Print (".. dir: %s\n", buf);
			break;
	case CMD_TON:	if (*p) get_term (buf, &p);
			else	strcpy (buf, DEFLOGFN);
			if (!(logfp = f_open (buf, "w"))) er = 1;
			else Print (".. Trace ON: %s\n", buf);
			break;
	case CMD_TOFF:	if (logfp) {
			    fclose (logfp);logfp = NULL;
			    Puts (".. Trace OFF\n");
			}
			break;
	case CMD_PROM:	if (i = *p) {
			    if ((i -= '0') >= 1 && i <= MAX_PROMPT) {
				while (*p && *p++ != '\'');
				for (q = p; *q && *q != '\''; q++);
				*q = 0;
				strncpy (prompt[i-1], p, 8);
			    } else {
			      Puts(".. Usage: .prompt n 'c..c' : n = 1..12\n");
			    }
			} else {
			    Puts(".. Prompt: ");
			    for (i = 0; i < MAX_PROMPT; i++) {
				if (i && (i % 6) == 0) Puts("\n           ");
				Print ("%d:'%s'  ", i+1, prompt[i]);
			    }
			    LFOUT;
			}
			break;
	case CMD_WAIT:	if ((i = atoi(p)) > 0) {
			    if (!cons_off) Print (".. wait %d sec\n", i);
#ifndef	DOS
			    signal(SIGALRM, time_out);
			    alarm(i);
#endif
			    wait_flg = 1;
			}
			break;
	case CMD_ALIAS:	if (*p) {
			    get_term (buf, &p);
			    if (q = find_def(1, buf)) {
				if (*p) rem_def (1, q);
				else	out_def(q);
			    }
			    if (*p) put_def (1, buf, p);
			    else if (!q) goto NOT_ALIAS;
			} else	list_def(1);
			break;
	case CMD_UNALIAS: if (*p) {
			    get_term (buf, &p);
			    if (strcmp(buf, "ALL")) {
				if (q = find_def(1, buf)) rem_def(1, q);
				else {
NOT_ALIAS:				Print(".. Not aliased: %s\n", buf);
				}
			    } else reset_def(1);
			}
			break;
	case CMD_DEF:	if (*p) {
			    get_term (buf, &p);
			    if (q = find_def(0, buf)) {
				if (*p) rem_def (0, q);
				else	out_def(q);
			    }
			    if (*p) put_def (0, buf, p);
			    else if (!q) goto NOT_DEF;
			} else list_def(0);
			break;
	case CMD_UNDEF:	if (*p) {
			    get_term (buf, &p);
			    if (strcmp(buf, "ALL")) {
				if (q = find_def(0, buf)) rem_def(0, q);
				else {
NOT_DEF:				Print(".. Not defined: %s\n", buf);
				}
			    } else reset_def(0);
			}
			break;
	case CMD_DO:	if (*p) {
			    if (nest >= MAX_NEST) {
				Puts(".. Too many nest\n");
				break;
			    }
			    get_term (buf, &p);
			    if (fp = f_open(buf, "r")) {
				infp[nest] = fp;
				strcpy (args[nest++], p);
			    } else Print(".. Can't open: %s\n", buf);
			}
			break;
	case CMD_SH:	if (*p) er = do_system (p);
			else	er = escape();
			break;
	case CMD_HELP:	for (pp = (uchar **)help_message; *pp; pp++) Puts(*pp);
			break;
	case CMD_REPT:	if (isdigit(*p)) {
			    get_term(buf, &p);
			    if ((i = atoi (buf)) < 0) i = 1;
			    repcnt[nest] = i;
			    strcpy (&repbuf[nest*LINE_LEN], p);
			} else {
			    Puts(".. Usage: .# nn command\n");
			}
			break;
	case CMD_PRINT:	Puts (p);	LFOUT;
	case CMD_CMNT:	break;
	case CMD_INPUT:	while (*p) {
			    get_term(buf, &p);
			    for (;;) {
				Print(".. %s ? ", buf);
				if (!(q = linein(NULL))) goto NEXT;
				if (*q) {
				    if (qq = find_def(0, buf)) rem_def(0, qq);
				    put_def (0, buf, q);
				    break;
				}
			    }
			}
			break;
	case CMD_BREAK:	do_break = 1;	break;
	case CMD_CONT:	do_break = 0;	break;
	case CMD_HIST:	q = hist + HIST_SZ - LINE_LEN - LINE_LEN;
			for (i = 0; q >= hist; q -= LINE_LEN) {
			    Print ("%2d: %s\n", ++i, q);
			    if ((i % 10) == 0) {if (more()) break;}
			}
			break;
	case CMD_CON:	cons_off = 0;	break;
	case CMD_COFF:	cons_off = 1;	break;

	case CMD_MLOAD:
#ifdef USE_LOADCMD
			if (*p) {
				do_multiload(p);
				last[2] = mode = 0;
				/*LFOUT;*/
				TYflush();
			}
#else
			Print ("Not implemented...\n"); er = 1;
#endif /* USE_LOADCMD */
			break;
	case CMD_TLOAD:
	case CMD_LOADM:
	case CMD_LOADX:
	case CMD_LOAD:
#ifdef USE_LOADCMD
		        if (*p) {
				do_load(cmd->id == CMD_TLOAD ? 0 : 1,
					cmd->id == CMD_LOADM ? 1 : 0,
					cmd->id == CMD_LOADX ? 1 : 0, p);
				last[2] = mode = 0;
				/*LFOUT;*/
				TYflush();
			}
#else
	  		Print ("Not implemented...\n"); er = 1;
#endif /* USE_LOADCMD */
			break;
	case CMD_SYMT:	get_term (buf, &p);
			symload(buf, p);	break;
	case CMD_EVAL:	get_term (buf, &p);
			symeval(buf, p);	break;

	case CMD_OUTWAIT:
			if ((i = atoi(p)) > 0) OUT_WAIT = i;
			Print("OutWait = %d\n", OUT_WAIT);
			break;
	case CMD_INWAIT:
			if ((i = atoi(p)) > 0) IN_WAIT = i;
			Print("InWait = %d\n", IN_WAIT);
			break;
	case CMD_CROUT:
			CR_OUT = (*p == '0' && *(p+1) == 0) ? 0 : 1;
			break;
	}
NEXT:
	if (er) Puts (".. ERROR ..\n");
	TYflush();
	RSclr();
	if (mode == 0) RSputc(CR);
	if (!nest || expand) show_prompt();
	return 1;
}
