/*
	gterm.h		gterm إå
*/
#include	<sys/param.h>

/* ץȥ */
typedef	unsigned char	uchar;
typedef	unsigned short	uhalf;

void	Putc(uchar c);
void	Puts(uchar *s);
void	Print(char *fmt, ...);
int	Getc(int f);
void	show_prompt();
int	RSgetc(int f);
void	RSputc(uchar c);
void	RSputs(uchar *s);
int	getline(int f);
uchar	*linein(uchar *s);
void	finish();
void	restart();
void	int_break();
FILE*	f_open(uchar *path, uchar *mode);
uchar	*skipsp(uchar *p);
uchar	*skipdelm(uchar *p);
void	get_term(uchar *buf, uchar **pp);
int	get_id(uchar *buf, uchar **pp);
uchar	*out_def(uchar *p);
int	more();
void	list_def(int alias);
void	reset_def(int alias);
void	put_def(int alias, uchar *buf, uchar *p);
void	rem_def(int alias, uchar *p);
uchar	*find_def(int alias, uchar *buf);
int	alias_line(uchar *d, uchar *s);
void	args_line(uchar *d, uchar *s);
void	make_line(uchar *d, uchar *s, int flg);
void	time_out();
int	do_cmd(uchar *d);

int	TYinit();
void	TYflush();
void	TYclr();
void	TYout(uchar c);
void	TYouts(uchar *s);
uchar	TYin();
int	Keytest(uchar c);
void	rs_reset_ptr();
int	RSinit(uchar *line, int baud);
void	RSclr();
void	rs_read();
int	RSin();
void	RSout(uchar c);
void	RSoutx(uchar c);
void	RSwrite(uchar *buf, int len);
int	PollRSTY();
int	escape();
void	sys_end(int i);
void	TYreinit();
int	do_system(char *s);
void	sleep_ms(int n);

int	RSgetx();
void	send_abort();
int	xymodem_send(int bnum, char *bufp, int dlen);
void	load_break();
uhalf	swap_h(uhalf h);
unsigned swap_w(unsigned h);
int	do_load(int xmodem, int memimg, int nocmd, uchar *p);
int	do_multiload(uchar *p);
void	symload(char *fn, char *p);
void	symeval(char *sym, char *p);

/* ¸ */
/* 
   __sparc__  ... Solaris(1.x/2.x) for SPARC
   BSD        ... FreeBSD 
   __linux__  ... Linux
   (others)   ... Solaris for x86
 */
#if defined(BSD) || defined(__sparc__)
#define USE_LOADCMD
#endif

/* default serial port */
#if defined(BSD)
#define	DEF_LINE	"/dev/cuaa1"		
#elif defined(__linux__)
#define	DEF_LINE	"/dev/ttyS1"		/* default serial port */
#else
#define	DEF_LINE	"/dev/ttyb"		
#endif
