/*
	load.c		gterm ɥޥɽ

	BMS LO ޥ:  LO {XS|XO|XM|XSYM|S|SYM}[,addr]
*/
#include	<stdio.h>
#include	<setjmp.h>
#include	<signal.h>
#include	<ctype.h>
#include	<string.h>
#include	<a.out.h>

#include	"devio.h"
#include	"crctable.h"		/* ãңåơ֥	*/
#include	"coff.h"
#include	"gterm.h"

#ifdef USE_LOADCMD
#define		EVAL_TIME		/* ֤¬		*/

FILE		*loadfp = NULL;
jmp_buf		load_jump;

#define	CR	('M'-'@')
#define	LF	('J'-'@')
#define	CAN	('X'-'@')
#define SOH	(0x01)
#define STX	(0x02)
#define EOT	(0x04)
#define ACK	(0x06)
#define NAK	(0x15)
#define CTLZ	('Z'-'@')

#define	DEF_BLKSZ	128

#define	XBLKSZ		1024		/* ˥֥å	*/

#define	MAX_RETRY	20

int	isBigEndian()
{
union	{
	short	s;
	char	c[2];
}	h;
	h.s = 0x1234;
	return h.c[0] == 0x12;
}

/*----------------------------------------------------------------------*/
int	RSgetx()
/*----------------------------------------------------------------------*/
{
	int	c;

	while ((c = RSgetc(0)) < 0);
	return c;
}
/*----------------------------------------------------------------------*/
void	send_abort()
/*----------------------------------------------------------------------*/
{
	RSoutx(CAN); RSoutx(CAN); RSoutx(CAN);
}
/*----------------------------------------------------------------------*/
int	xymodem_send(int bnum, char *bufp, int dlen)
/*----------------------------------------------------------------------*/
{
static	int	USE_CRC;
	int	i, retry, ck, blksz = 0;
	char	*bp;

	if (bnum <= 0) {	/* bnum < 0 : YMODEM	*/
		for (;;) {
			if ((i = RSgetx()) == NAK) {USE_CRC = 0; break;}
			if (i == 'C') {USE_CRC = 1; break;}
			if (i == CAN) goto XCANCEL;
			/* do {sleep_ms(100);} while (RSgetc(0) >= 0); */
		}
	}

	if (dlen > 0) {
		blksz = (dlen <= DEF_BLKSZ) ? DEF_BLKSZ : XBLKSZ;
		bp = bufp + 3;
		while (dlen < blksz) bp[dlen++] = CTLZ;
		if (USE_CRC) {
			for (ck = i = 0; i < blksz; i++) {
				ck = (ck << 8) ^ crc_table[((ck >> 8) ^
						(uhalf)(*bp++)) & 0xff];
			}
			*bp++ = ck >> 8;
			*bp = ck & 0xff;
		} else {
			for (ck = i = 0; i < blksz; i++) ck += *bp++;
			*bp = ck & 0xff;
		}
	}

	bnum = (bnum + 1) & 0xff;
	for (retry = 0; retry < MAX_RETRY; retry++) {
		if (dlen <= 0) RSoutx(EOT);
		else {
			bufp[0] = (blksz == DEF_BLKSZ) ? SOH : STX;
			bufp[1] = bnum;
			bufp[2] = 0xff - bnum;
			RSwrite(bufp, blksz + 3 + (USE_CRC ? 2 : 1));
		}
		for (;;) {
			if ((i = RSgetx()) == ACK) return (dlen <= 0) ? 1 : 0;
			if (i == NAK) break;
			if (i == CAN && RSgetx() == CAN) goto XCANCEL;
			/* do {sleep_ms(100);} while (RSgetc(0) >= 0); */
		}
		Putc('!');
		TYflush();
	}
	send_abort();
	Print(".. Retry Over");
	return -1;

XCANCEL:
	Print(".. Cancelled");
	return -1;
}
/*----------------------------------------------------------------------*/
void	load_break()
/*----------------------------------------------------------------------*/
{
	longjmp (load_jump, 1);
}
/*----------------------------------------------------------------------*/
uhalf	swap_h(uhalf h)
/*----------------------------------------------------------------------*/
{
	return (h >> 8) | (h << 8);
}
/*----------------------------------------------------------------------*/
unsigned swap_w(unsigned w)
/*----------------------------------------------------------------------*/
{
	return (w >> 24) | ((w >> 8) & 0xff00) | ((w << 8) & 0xff0000) | (w << 24);
}
/*----------------------------------------------------------------------*/
void	swab_exec(OPTINFO *p)
/*----------------------------------------------------------------------*/
{
	p->magic = swap_h(p->magic);
	p->vstamp = swap_h(p->vstamp);
	p->tsize = swap_w(p->tsize);
	p->dsize = swap_w(p->dsize);
	p->bsize = swap_w(p->bsize);
	p->entry = swap_w(p->entry);
	p->text_start = swap_w(p->text_start);
	p->data_start = swap_w(p->data_start);
}
/*----------------------------------------------------------------------*/
void	swab_secthdr(SECTHDR *p)
/*----------------------------------------------------------------------*/
{
	p->s_paddr = swap_w(p->s_paddr);
	p->s_vaddr = swap_w(p->s_vaddr);
	p->s_size = swap_w(p->s_size);
	p->s_scnptr = swap_w(p->s_scnptr);
	/* ... */
}
/*----------------------------------------------------------------------*/
/*	ž٤Ǥʤãɤ
*/
int	stop_copy(SECTHDR *shdr)
{
static	char	*secnam[] = {
	".sbss",
	".bss",
	NULL
};
	char	**pp = secnam;
	while (*pp != NULL) {
		if (memcmp(shdr->s_name, *pp, strlen(*pp)) == 0)
			return 1;
		pp++;
	}
	return 0;
}

/*----------------------------------------------------------------------*/
/*	žǽʥ֥Ȥ Little endian  COFF ե	*/
/*	ޤϡBig Endian  a.out ե				*/

int	do_load(int xmodem, int memimg, int nocmd, uchar *p)
{
	FILEHDR		fhdr;
	int		i, n, k;
	uchar		buf[1024+64];
	uchar		cmd[32];
	union {
		OPTINFO		opt;	/* struct exec ȤϰäƤ */
		struct exec	exec;
		char		c;
		unsigned long	magic;
	} head;
	char		form;
	uchar		*q;
	int		sz, tsz;
	int		ofmt;
	int		bigendian;
#ifdef	EVAL_TIME
	long		tm;
#endif

#define zMAGIC		0x10C		/* ǥޥɥɷ		*/
#define	COFFfmt		1
#define	AOUTfmt		2
#define	AOUTZfmt	3
#define	AOUTRfmt	4

	/* եΥץ */
	get_term(buf, &p);
	if (!(loadfp = f_open (buf, "r"))) {
		if (nocmd < 0) RSputc(NAK);
		Print(".. Can't Open: %s", buf);
		goto EXIT;
	}

	/* եΥå */

	/* COFF magic 뤫Ĵ٤ */
	if ((sz = fread(&fhdr, 1, sizeof(fhdr), loadfp)) <= 0) {
		Print(".. Can't Read");
		goto EXIT;
	}
#ifdef	DEBUG
	Print("fhdr.f_magic=%04x\n", fhdr.f_magic);
#endif
	if (fhdr.f_magic == COFF_MAGIC) {
		/* little endian machine  little endian COFF  */
		ofmt = COFFfmt;
		bigendian = 0;
	} else if (fhdr.f_magic == swap_h(COFF_MAGIC)) {
		/* bigendian machine  little endian COFF format */
		ofmt = COFFfmt;
		bigendian = 1;
	} else {
		ofmt = 0;
		bigendian = isBigEndian();
		rewind(loadfp);
	}
	if ((sz = fread(&head, 1, sizeof(head), loadfp)) <= 0) {
		Print(".. Can't Read");
		goto EXIT;
	}
	rewind (loadfp);

	if (ofmt == COFFfmt && bigendian) {
		swab_exec(&head.opt);
	}

	if (sz != sizeof(head)) {
		form = 'M';
	} else if (head.c == 'S') {		/* S եޥå	*/
		form = 'S';
	} else if (ofmt == COFFfmt) {
		form = 'O';			/* COFF եޥå	*/
	} else if (head.exec.a_magic == OMAGIC ||
		   head.exec.a_magic == NMAGIC ||
		   head.exec.a_magic == ZMAGIC ||
		   head.exec.a_magic == zMAGIC) {
		form = 'O';			/* a.out եޥå	*/
		ofmt = AOUTfmt;

	} else if (head.magic == swap_w(OMAGIC) ||
		   head.magic == swap_w(ZMAGIC)) {
			/* little endian (LE) a.out եޥå	*/

		form = 'O';			/* a.out եޥå	*/
		ofmt = (head.magic == swap_w(ZMAGIC)) ? AOUTZfmt : AOUTRfmt;
		head.exec.a_text = swap_w(head.exec.a_text);
		head.exec.a_data = swap_w(head.exec.a_data);
		head.exec.a_bss = swap_w(head.exec.a_bss);
		head.exec.a_syms = swap_w(head.exec.a_syms);
		head.exec.a_entry = swap_w(head.exec.a_entry);
		head.exec.a_trsize = swap_w(head.exec.a_trsize);
		head.exec.a_drsize = swap_w(head.exec.a_drsize);

	} else {
		/* 16ʿ򥹥å */
		q = (uchar*)&head.c;
		strtol(q, &q, 16);
		if ((q - (uchar *)&head.c) >= 8)
			/* 8 ʸʾ 16 ʿͤ */
			form = 'Y';	/* ӣ٣ͥơ֥	*/
		else
			form = 'M';	/* ꥤ᡼ǡ */
	}

	if (memimg < 0) {
		ofmt = 0;
		form = 'M';
	}

	if (form == 'O') {
		if (ofmt == COFFfmt) {
			/* COFF ξ fhdr, SECTHDR ⤹٤ž */
			SECTHDR	shdr;
			W	nscns = bigendian ? swap_h(fhdr.f_nscns)
					  : fhdr.f_nscns;

			/* إåΥ */
			tsz = sizeof(fhdr) + sizeof(OPTINFO)
					+ sizeof(SECTHDR) * nscns;
			/* ƥǡΥ */
			fseek(loadfp, sizeof(fhdr) + sizeof(OPTINFO), 0);
			for (i = 0; i < nscns; i++) {
				fread(&shdr, 1, sizeof(SECTHDR), loadfp);
				if (bigendian) swab_secthdr(&shdr);
				/* sbss  bss μޤǥԡ */
				if (stop_copy(&shdr)) break;
				tsz += shdr.s_size;
#ifdef DEBUG
				Print("section %2d size = 0x%x\n",
							i, shdr.s_size);
#endif
			}
			rewind(loadfp);
		} else {	/* a.out  */
			tsz = head.exec.a_text + head.exec.a_data;

			if (ofmt == AOUTZfmt) {
				/* LE ZMAGIC: إå 4KB */
				tsz += 4096;

			} else if (ofmt == AOUTRfmt) {
				/* LE OMAGIC: relocation  */
				tsz += sizeof(struct exec) +
					head.exec.a_trsize +
					head.exec.a_drsize;

			} else if (head.exec.a_magic != zMAGIC) {
				tsz += sizeof(struct exec);
			}
			if (memimg) form = 'M';
		}
	} else {
		/* եΤž */
		fseek(loadfp, 0, 2);
		tsz = ftell(loadfp);
		rewind(loadfp);
	}
	if (nocmd < 0) form = 'F';

	if (xmodem == 0 && (form == 'O' || form == 'M')) {
		Print(".. Must Use .load");
		goto EXIT;
	}

	cmd[0] = 'L';	cmd[1] = 'O';	cmd[2] = ' ';
	i = 3;
	if (xmodem) cmd[i++] = 'X';
	if (form == 'Y') {cmd[i++] = 'S'; cmd[i++] = 'Y'; cmd[i++] = 'M';}
	else		 {cmd[i++] = form;}
	cmd[i] = 0;

	if (*p) {
#if	0
		if (form == 'Y') {
			Print(".. Can't Specify address");
			goto EXIT;
		}
#endif
		cmd[i++] = ',';
		get_term(&cmd[i], &p);
	} else if (form == 'M') {
		Print(".. Must Specify address");
		goto EXIT;
	}

	if (setjmp(load_jump)) {
		Puts("^C");
		if (xmodem) {
			while ((n = RSgetx()) != NAK && n != ACK);
		}
		send_abort();
		goto EXIT;
	}
	signal(SIGINT, load_break);

#ifdef	EVAL_TIME
	tm = time(NULL);
#endif

	/* ޥɤ */
	if (nocmd == 0) RSputs(cmd);
	else if (nocmd < 0) {
		sprintf(cmd, "*%d", tsz);
		for (i = 0; cmd[i]; i++) RSputc(cmd[i]);
		RSputc(ACK); cmd[0] = 0;
	}

	if (cmd[0]) Print(".. %s [%s: %d bytes", cmd, buf, tsz);
	else	    Print(".. [%s: %d bytes", buf, tsz);

	if (ofmt) {
		if (ofmt == COFFfmt) {
			Print(": COFF<T:%d D:%d B:%d>", head.opt.tsize,
					head.opt.dsize, head.opt.bsize);
		} else if (ofmt == AOUTRfmt) {
			Print(": A.OUT-R<T:%d D:%d B:%d R:%d/%d>",
				head.exec.a_text,
				head.exec.a_data, head.exec.a_bss,
				head.exec.a_trsize, head.exec.a_drsize);
		} else if (ofmt == AOUTZfmt) {
			Print(": A.OUT-Z<T:%d D:%d B:%d>", head.exec.a_text,
				head.exec.a_data, head.exec.a_bss);
		} else {
			Print(": A.OUT<T:%d D:%d B:%d>", head.exec.a_text,
				head.exec.a_data, head.exec.a_bss);
		}
	}
	Print("]\n");

	sleep_ms(10);

	/* ºݤΥǡ */
	if (xmodem) {	/* أͣϣģţͥ */
		for (i = k = 0, sz = tsz; ; i++) {
			if ((n = sz) > XBLKSZ) n = XBLKSZ;
			if (n) {
				if (fread(&buf[3], 1, n, loadfp) != n) {
					Print(".. Can't Read");
					send_abort();
					break;
				}
				sz -= n;
			}
			if (xymodem_send(i, buf, n)) break;
			if ((k += n) % (2048) == 0) {
				Putc((k % 10240) ? '.' : '*');
				TYflush();
			}
		}

	} else {	/* ̵ */
		for (k = 0; (i = getc(loadfp)) != EOF;) {
			RSoutx(i);
			if ((++k) % 32 == 0) {
				sleep_ms(1);
				if (k % 2048 == 0) {
					Putc((k % 10240) ? '.' : '*');
					TYflush();
				}
			}
		}
		sleep_ms(10);
		if (form == 'Y') send_abort();
	}

#ifdef	EVAL_TIME
	tm = time(NULL) - tm;
	if (tm <= 0) tm = 1;
	Print(" (%d.%d bytes/sec)\n", tsz / tm, (tsz % tm) * 10 / tm);
#endif

EXIT:
	if (loadfp) fclose(loadfp);
	loadfp = NULL;
	signal(SIGINT, int_break);
}
/*----------------------------------------------------------------------*/
int	do_multiload(uchar *p)	/* ٣ͣϣģţͤˤʣեΥ*/
/*----------------------------------------------------------------------*/
{
	int		i, n, k, c, er;
	uchar		buf[1024+64];
	uchar		src_name[64+1];
	uchar		dst_name[64+1];
	int		sz, tsz;
	FILE		*fnamefp;

#ifdef	EVAL_TIME
	long		tm;
#endif
	/* ꥹȥեΥץ */
	get_term(buf, &p);
	if (!(fnamefp = f_open (buf, "r"))) {
		Print(".. Can't Open: %s", buf);
		return;
	}

	/* ʣեž */
	for (;;) {
		tsz = er = 0;

		/* ꥹȥե륨ȥμФ */
		if (fgets(buf, sizeof(buf), fnamefp)) {
			if (buf[0] == 0 || buf[0] == '\n') continue;
			for (i = 0; i < sizeof(buf); i++) {
				if ((c = buf[i]) > ' ' || c == '\n') break;
			}
			for (n = 0; i < sizeof(buf); i++) {
				if ((c = buf[i]) <= ' ') break;
				if (n < 64) src_name[n++] = c;
			}
			src_name[n] = 0;
			for (; i < sizeof(buf); i++) {
				if ((c = buf[i]) > ' ' || c == '\n') break;
			}
			for (n = 0; i < sizeof(buf); i++) {
				if ((c = buf[i]) < ' ') break;
				if (n < 64) dst_name[n++] = c;
			}
			dst_name[n] = 0;
			if (src_name[0] == 0 || dst_name[0] == 0) {
				Print(".. Illegal List format: %s", buf);
				continue;
			}

			/* ɥեΥץ */
			if (!(loadfp = f_open(src_name, "r"))) {
				Print(".. Can't Open: %s", src_name);
				continue;
			}
			/* ե륵μФ */
			fseek(loadfp, 0, 2);
			tsz = ftell(loadfp);
			rewind(loadfp);
		}
		if (setjmp(load_jump)) {
			Puts("^C");
			while ((n = RSgetx()) != NAK && n != ACK);
			send_abort();
			goto EXIT;
		}
		signal(SIGINT, load_break);

#ifdef	EVAL_TIME
		tm = time(NULL);
#endif
		if (tsz) Print("%s -> %s (%d bytes)\n",src_name, dst_name,tsz);

		sleep_ms(10);

		/* إå٣ͣϣģţ */
		memset(&buf[3], 0, DEF_BLKSZ);
		if (tsz) {
			strcpy(&buf[3], dst_name);
			n = strlen(&buf[3]);
			sprintf(&buf[3 + n + 1], "%d", tsz);
		}
		if ((er = xymodem_send(-1, buf, DEF_BLKSZ)) == 0) {
			/* ºݤΥǡ٣ͣϣģţ */
			if (sz = tsz) for (i = k = 0; ; i++) {
				if ((n = sz) > XBLKSZ) n = XBLKSZ;
				if (n) {
					if (fread(&buf[3], 1, n, loadfp) != n){
						Print(".. Can't Read");
						send_abort();
						break;
					}
					sz -= n;
				}
				if (er = xymodem_send(i, buf, n)) break;
				if ((k += n) % (2048) == 0) {
					Putc((k % 10240) ? '.' : '*');
					TYflush();
				}
			}
		}

#ifdef	EVAL_TIME
		if (tsz) {
			tm = time(NULL) - tm;
			if (tm <= 0) tm = 1;
			Print(" (%d.%d bytes/sec)\n", tsz / tm,
							(tsz % tm) * 10 / tm);
		}
#endif
EXIT:
		if (loadfp) fclose(loadfp);
		loadfp = NULL;
		signal(SIGINT, int_break);
		if (tsz == 0 || er < 0) break;
	}
	fclose(fnamefp);
	Print("End of MLOAD\n");
}
#endif /* USE_LOADCMD */
