/*
	bzcomp.c  98-03-18

	¹ԥץΰ
	(C) Copyright 1997-98 by Personal Media Corporation

	 оݥեϥȥ륨ǥ
*/
#include	<stdio.h>
#include	<stdlib.h>
#include	<string.h>
#include	<fcntl.h>
#include	<unistd.h>
#include	<errno.h>

#include	<basic.h>
#include	<errcode.h>
#include	<bzcomp.h>

#define P	printf

char* strerror( int err )
{
	char	buf[128];
	return sprintf(buf, "%d", err);
}

Inline UH swapH( UH x )
{
	return (x << 8) | (x >> 8);
}
Inline UW swapW( UW x )
{
	return (UW)swapH((UH)x) << 16 | swapH((UH)(x >> 16));
}

#if BIGENDIAN
#define	CEW(x)	swapW(x)
#else
#define	CEW(x)	(x)
#endif

/* 쥳ɰ̽ */
#include	"comp.h"
IMPORT	VOID	CompWriteInit(FUNCP wfn);
IMPORT	W	CompWrite(VP buf, W len);

LOCAL	Bool	Verbose;
LOCAL	Bool	SysProc;

/*
	̥쥳ɽ񤭹
*/
#define	MAGIC1	CEW(BzMAGIC1)	/* ޥåʥ1 */
#define	MAGIC1S	CEW(BzMAGIC1S)	/* ޥåʥ1 (ƥץ) */
#define	MAGIC2	CEW(BzMAGIC2)	/* ޥåʥ2 */
#define	MAGIC3	CEW(BzMAGIC3)	/* ޥåʥ3 */

LOCAL	B*	wBuf;
LOCAL	W	wLen;
LOCAL	W	wBufLen;

LOCAL	W	WriteFn(VP buf, W len)
{
	if (wLen + len > wBufLen) return -1000;
	memcpy(&wBuf[wLen], buf, len);
	wLen += len;
	return 0;
}
LOCAL	W	CompRec(char *fn, W fd, W sz)
{
	W	er, rsz;
	B	*rBuf;
	Bz_HDR	*bhd;

	/* Хñ̤ڤ夲 */
	wBufLen = (sz + 7) & ~7;

	/* Хåե */
	wBuf = malloc(wBufLen * 2);
	if (wBuf == NULL) {
		P("%s: No Memory\n", fn);
		er = ER_NOMEM;
		goto EEXIT;
	}
	rBuf = wBuf + wBufLen;

	/* 쥳ɰɤ߹ */
	if (lseek(fd, 0, SEEK_SET) < 0
	 || read(fd, rBuf, sz) != sz) {
		P("%s: Can't Read (%s)\n", fn, strerror(errno));
		goto EEXIT;
	}

	bhd = (Bz_HDR *)rBuf;
	if ( (bhd->magic1 == MAGIC1 || bhd->magic1 == MAGIC1S)
	  && bhd->magic2 == MAGIC2 && bhd->magic3 == MAGIC3 ) {
		P("%s: Already Compressed\n", fn);
		goto EEXIT;
	}

	/* ̥쥳ɥإå */
	bhd = (Bz_HDR *)wBuf;
	bhd->magic1 = ( SysProc )? MAGIC1S: MAGIC1;
	bhd->magic2 = MAGIC2;
	bhd->magic3 = MAGIC3;
	bhd->expsz = CEW(sz);
	wLen = sizeof(Bz_HDR);

	/* ̽񤭹߽ */
	CompWriteInit(WriteFn);

	/* ̽() */
	er = CompWrite(rBuf, sz);
	if (er >= 0) er = CompWrite(rBuf, 0);
	if (er < 0) {
		if (er == -1000) {
			P("%s: Unchanged\n", fn);
			er = 0;
		} else {
			P("%s: Can't Compress (%d)\n", fn, er);
		}
		goto EEXIT;
	}

	/* ̥쥳ɽ񤭹 */
	if (lseek(fd, 0, SEEK_SET) < 0
	 || write(fd, wBuf, wLen) != wLen) {
		P("%s: Can't Write Rec (%s)\n", fn, strerror(errno));
		goto EEXIT;
	}
	if (ftruncate(fd, wLen) < 0) {
		P("%s: Can't Truncate Rec (%s)\n", fn, strerror(errno));
		goto EEXIT;
	}

	if (Verbose == True) {
		P ("%s: Compress %d --> %d [%d%%]\n", fn, sz, wLen,
					wLen * 100 / sz);
	}
	er = ER_OK;
EEXIT:
	if (wBuf != NULL) free(wBuf);
	return er;
}
/*
	ᥤ
*/
EXPORT	int	main(int ac, char *av[])
{
	W	n, fd, sz;
	char	*s;

	Verbose = False;
	SysProc = False;

	/* ץμФ */
	for (av++; --ac > 0; av++) {
		s = *av;
		if (*s++ != '-') break;
		switch (*s++) {
		case 'v':	Verbose = True;		break;
		case 's':	SysProc = True;		break;
		default:	goto USAGE;
		}
	}
	if (ac < 1) {
USAGE:		P("Usage: bzcomp [-v] [-s] file ...\n");
		P("       -v:Verbose\n");
		P("       -s:System Process\n");
		return ER_PAR;
	}

	fd = -1;
	for (n = 0; n < ac; n++) {

		if (fd >= 0) close(fd);
		s = av[n];

		if ((fd = open(s, O_RDWR)) < 0) {
			P("%s: Can't Open (%s)\n", s, strerror(errno));
			continue;
		}

		if ((sz = lseek(fd, 0, SEEK_END)) < 0) {
			P("%s: Can't Seek (%s)\n", s, strerror(errno));
			continue;
		}

		CompRec(s, fd, sz);
	}
	if (fd >= 0) close(fd);
	return 0;
}
