/*
	debug.c		gterm	1B ǥХå⡼ɽ
*/
#include	<stdio.h>
#include	<memory.h>
#include	<ctype.h>

#include	"devio.h"
#include	"gterm.h"

#define	LF		0x0a
#define	SYMT_SZ		32728

static	uchar	*symt = NULL;
static	uchar	*symte = NULL;
static	uchar	*symt_tab[4] = {NULL,NULL,NULL,NULL};
static	uchar	*symte_tab[4] = {NULL,NULL,NULL,NULL};

static	uchar	buff[256], *bufp;
static	int	cur_seg, cur_off;
static	int	base_seg, base_off;
static	int	symt_num = 0;

static	char	*helpm[] = {
	"XDEBUGGER COMMAND:\n",
	" <adrs>[H|W|L]	display memory (byte, word, long)\n",
	" <num>:	set segment\n",
	" <adr>M	modify memory\n",
	" <adrs>P<num>	painet memory\n",
	" <num>S	step execution (num times)\n",
	" X		examine registers\n",
	" <adrs>U	disassemble\n",
	" <adr>G	execute with break\n",
	" <adr>=<_sym>	define symbol\n",
	" l<symfile>	load symbol table file (*.nm)\n",
	" <adr>@	set base address\n",
	" <adr>?	evaluate adr\n",
	" t<num>	switch symbol table (0-3)\n",
	" H		display this message\n",
	"ADDRESS FORMAT:\n",
	" <adrs> = <adr>,<adr>|,<adr>|<adr>,+<num>|,+<num>|<adr>\n",
	" <adr>  = <ad |<adr>+<num>|<adr>-<num>\n",
	" <ad>   = <num>|[<num>|CS|SS|DS|ES]:<num>|<_sym>|@<num>\n",
	NULL};

/*
*/
static	int	Hexval(int c)
{
	if (c >= '0' && c <= '9') return c - '0';
	if (c >= 'A' && c <= 'F') return c - 'A' + 10;
	if (c >= 'a' && c <= 'f') return c - 'a' + 10;
	return 20;	/* illegal */
}
/*
*/
static	int	GetVal()
{
	uchar	c;
	int	val, n;

	val = 0;
	while ((c = TYin()) != LF && c != 0x0d) {
		if (c) {
			Putc(c);
			if ((n = Hexval(c)) < 16) val = (val << 4) + n;
			else { Puts("-? "); val = 0;}
			TYflush();
		}
	}
	Putc(LF);
	return val;
}
/*
*/
static	uchar	*SetSym(uchar *s)
{
	uchar	c, *p, *q;
	int	n, i, j0, j1;
	uchar	tmp[50];

	for (i = 0;;) {
	     if ((c = *s++) == '_' || isalnum(c)) tmp[i++] = c;
	     else break;
	}
	tmp[i] = 0;
	if (!symt) goto UNDEF;

	for (p = symt; n = *p; p += n + 5) {
		if (n == i && memcmp(p + 5, tmp, n) == 0) break;
	}

	if (n) {
		i  = *++p  << 8;
		if ((i += *++p) & 0x8000) {
			sprintf(tmp, "Seg #%d addr? ", i);
			j0 = (i >> 8) & 0xff;
			j1 = i & 0xff;
			Puts(tmp);
			if ((i = GetVal()) == 0) return NULL;
			for (q = symt; n = *q++; q += n + 4) {
				if (*q == j0 && *(q+1) == j1) {
					*q = (i >> 8) & 0xff;
					*(q+1) = i & 0xff;
				}
			}
	    }
	    cur_seg = i;
	    cur_off = *++p << 8;
	    cur_off += *++p;
	    s--;
	    while (*s == ' ') s++;
	    return s;
	}
UNDEF:
	Puts("Undefined symbol: ");
	Puts(tmp);
	Putc(LF);
	return NULL;
}
/*
*/
static	void	SetSeg()
{
	    if (cur_seg == -1)		sprintf(bufp, "CS:");
	    else if (cur_seg == -2)	sprintf(bufp, "SS:");
	    else if (cur_seg == -3)	sprintf(bufp, "DS:");
	    else if (cur_seg == -4)	sprintf(bufp, "ES:");
	    else			sprintf(bufp, "%x:", cur_seg);
	    bufp += strlen(bufp);
}
/*
*/
static	uchar	*SetAddr(uchar *s, int	seg)
{
	int	n, val, sign, segflg, offflg;

	if (*s == '_') {
		if (!(s = SetSym(s))) return NULL;	/* symbol */
		offflg = segflg = 1;
	} else {					/* hexadecimal */
		offflg = segflg = 0;
		if (*s == '@') {
			cur_seg = base_seg;
			cur_off = base_off;
			seg = 0;
			segflg = offflg = 1;
			s++;
		} else if (*s == '+') {
			seg = 0;
			s++;
		} else cur_off = 0;

		if ((*(s+1) == 'S' || *(s+1) == 's') && *(s+2) == ':' && seg) {
			if (*s == 'C' || *s == 'c')	 seg = -1;
			else if (*s == 'S' || *s == 's') seg = -2;
			else if (*s == 'D' || *s == 'd') seg = -3;
			else if (*s == 'E' || *s == 'e') seg = -4;
			if (seg < 0) {
				cur_seg = seg;
				seg = offflg = 0;
				segflg = 1;
				s += 3;
			}
		}

		for (val = 0;;) {
			while ((n = Hexval(*s++)) < 16) {
				offflg = 1;
				val = (val << 4) + n;
			}
			if (*--s == ':' && seg) {
				cur_seg = val;
				val = 0;
				s++;
				seg = offflg = 0;
				segflg = 1;
			} else break;
		}
		cur_off += val;
	}

	for (;;) {
		if (*s == '+') sign = 0;
		else if (*s == '-') sign = 1;
		else break;
		val = 0;
		while ((n = Hexval(*++s)) < 16) val = (val << 4) + n;
		cur_off += (sign) ? - val : val;
	}

	if (segflg) SetSeg();
	if (offflg) {
		sprintf(bufp, "%x", cur_off);
		bufp += strlen(bufp);
	}
	return s;
}
/*
*/
static	void	ReadSymFile(uchar *fn)
{
	FILE	*fp;
	int	n, j0, j1, k0, k1;
	uchar	*p, tmp[128];

	if (!symt) {
		if (!(symt = (uchar *)malloc(SYMT_SZ))) {
			Puts("Can't allocate memory !!\n");
			return;
		}
	}
	strcpy(tmp, fn);
	n = strlen(tmp);
	if (tmp[n-1] != 'm' || tmp[n-2] != 'n') strcat (tmp, ".nm");
	if (!(fp = fopen (tmp, "r"))) {
		Puts("Can't Open symbol file: ");
		Puts(tmp);
		Puts(" !!\n");
		n = 0;
	} else {
		n = fread(symt, 1, SYMT_SZ, fp);
	}
	fclose(fp);
	symt[n] = symt[n+1] = 0;
	symte = &symt[n];

	/* set seg address */
	for (p = symt, n = *p++; n; ) {
		j0 = *p;
		j1 = *(p+1);
		sprintf(tmp, "Seg #%x addr? ", (j0 << 8) + j1);
		Puts (tmp);
		if (k0 = GetVal()) {k1 = k0 & 0xff; k0 = (k0 >> 8) & 0xff;}
		else		{k1 = j1; k0 = j0;}

		do { *p++ = k0; *p++ = k1; p += n + 2;
		} while ( (n = *p++) && (*p == j0 && *(p+1) == j1) );
	}
}
/*
*/
static	void	PutSym(uchar *s)
{
	int	i, n;
	uchar	c, *p;
	uchar	tmp[50];

	for (i = 0;;) {
		if ( ( c = *s++) == '_' || isalnum(c)) tmp[i++] = c;
		else break;
	}
	tmp[i] = 0;

	if (symt) {
		for (p = symt; n = *p; p += n + 5) {
			if (n == i && memcmp(p + 5, tmp, n) == 0) break;
		}
		p[0] = i;
		p[1] = (cur_seg >> 8) & 0xff;
		p[2] = cur_seg & 0xff;
		p[3] = (cur_off >> 8) & 0xff;
		p[4] = cur_off & 0xff;
		memcpy(&p[5], tmp, i);
		if (n) {
			Puts("re-defined !!\n");
		} else {
			symte += i + 5;
			symte[0] = symte[1] = 0;
		}
	} else {
		Puts("L must be done !!\n");
	}
}
/*
*/
static	int	SearchSym(int seg, int off)
{
	uchar	*p, *pp;
	int	n, i0, i1;

	if (!symt) return;

	i0 = (seg >> 8) & 0xff;
	i1 = seg & 0xff;
	for (p = symt; n = *p++; p += n + 4) {
		if (*p == i0 && *(p + 1) == i1) {
			pp = p;
			do {
				if (off < ( (*(p + 2) << 8) + *(p + 3))) break;
				pp = p;
				p += n + 4;
			} while ((n = *p++) && *p == i0 && *(p + 1) == i1);
			n = 1;
			break;
		}
	}
	if (n) {
		n = *(pp - 1);
		off -= (*(pp + 2) << 8) + *(pp + 3);
		memcpy(bufp, pp + 4, n);
		bufp += n;
		*bufp++ = '+';
		sprintf(bufp, "%x", off);
	}
}
/*
*/
int	DoDebug(uchar *sp)
{
	uchar	*pp, *xp, *ip;
	int	i, adr2;

	for (; *sp == ' '; sp++);
	ip = sp;

	bufp = buff;
	if (*sp == '.' || *sp == ',') {
		SetSeg();
		sprintf(bufp, "%x", ++cur_off);
		bufp += strlen(bufp);
	} else {
		if (!(sp = SetAddr(sp, 1))) return 1;	/* get 1st address */
	}

	while (*sp == ' ') sp++;
	if (*sp == '.' || *sp == ',') {
		*bufp++ = ',';
		while (*++sp == ' ');
		if (!(sp = SetAddr(sp, 1))) return 1;	/* get 2nd address */
		while (*sp == ' ') sp++;
		adr2 = 1;
	} else adr2 = 0;

	switch (*(pp = sp)) {
	case 'h':
	case 'H':
		if (ip == sp) {
			for (i = 0; helpm[i]; i++) Puts(helpm[i]);
			return 1;
		}
		if (*++sp) goto errr;
		if (adr2 == 0) {
			*bufp++ = ',';
			SetAddr("+7", 1);		/* set 2nd address */
		}
		*bufp++ = 'H';
		break;
	case 'l':
	case 'L':
		if (ip == sp) {
			while (*++sp == ' ');
			ReadSymFile(sp);
			return(1);
		}
		if (*++sp) goto errr;
		if (adr2 == 0) {
			*bufp++ = ',';
			SetAddr("+1c", 1);		/* set 2nd address */
			cur_off += 3;
		}
		*bufp++ = 'L';
		break;
	case 'w':
	case 'W':
		if (*++sp) goto errr;
		if (adr2 == 0) {
			*bufp++ = ',';
			SetAddr("+e", 1);		/* set 2nd address */
			cur_off += 1;
		}
		*bufp++ = 'W';
		break;
	case 'm':
	case 'M':
		if (*++sp) goto errr;
		*bufp++ = 'M';
		break;
	case 'p':
	case 'P':
		*bufp++ = 'P';
		while (*++sp == ' ');
		sp = SetAddr(sp, 0);
		if (*sp) goto errr;
		break;
	case 's':
	case 'S':
		if (*++sp) goto errr;
		*bufp++ = 'S';
		break;
	case 'u':
	case 'U':
		if (*++sp) goto errr;
		*bufp++ = 'U';
		break;
	case 'g':
	case 'G':
		if (*++sp) goto errr;
		*bufp++ = 'G';
		break;
	case 'x':
	case 'X':
		if (*++sp) goto errr;
		*bufp++ = 'X';
		break;
	case '@':
		if (*++sp) goto errr;
		base_seg = cur_seg;
		base_off = cur_off;
		Puts("*base = ");
		Puts(buff);
		Putc(LF);
		return 1;
	case '=':
		while (*++sp == ' ');
		PutSym(sp);
		return 1;
	case '?':
		if (*++sp) goto errr;
		sprintf(bufp, " (%d '%o)  ", cur_off, cur_off);
		bufp = bufp + strlen(bufp);
		SearchSym(cur_seg, cur_off);
		strcat(bufp, "\n");
		Puts(buff);
		return 1;
	case 't': case 'T':
		i = *++sp - '0';
		if (i < 0 || i > 3) goto errr;
		symt_tab[symt_num] = symt;
		symte_tab[symt_num] = symte;
		if (i != symt_num) {
			symt = symt_tab[i];
			symte = symte_tab[i];
		}
		sprintf(bufp, "SYMT %d <== %d\n", i, symt_num);
		Puts(buff);
		symt_num = i;
		return 1;
	case 0:
		if (adr2 == 0) {
			*bufp++ = ',';
			SetAddr("+7", 1);		/* set 2nd address */
		}
		break;
	default:
errr:
		Puts("Illegl command:");
		Puts(pp);
		Putc(LF);
		return 1;
	}
	*bufp++ = LF;
	*bufp++ = 0;
	RSputs(buff);
	return 0;
}
