/*
	devio.c		gterm	ǥХ I/O 
*/

#ifdef USE_OLD_DEVIO
#ifdef __sun__
/* /usr/include/sys/ioctl.h  CBREAK */
#define BSD_COMP 1
#endif /* __sun__ */
#endif /* USE_OLD_DEVIO */

#include	<stdio.h>
#include	<sys/file.h>
#include	<fcntl.h>
#include	<sys/ioctl.h>
#include	<sys/param.h>
#include	<setjmp.h>
#include	<sys/time.h>
#ifdef USE_OLD_DEVIO
#include	<sgtty.h>
#else
#include        <termios.h>
#include        <sys/types.h>
#include        <unistd.h>
#ifdef __sun__
#include	<sys/filio.h>
#endif /* __sun__ */
#endif /* USE_OLD_DEVIO */

#include	"devio.h"
#include	"gterm.h"

#define	PATHMAX_SUN	1024

#define	ESC	0x1b
#define	NL	0x0a
#define	CR	0x0d

int	tty_fd;
#ifndef USE_OLD_DEVIO
struct	termios	rs_arg, sgtty, savetty;
#else
struct	sgttyb	sgtty, savetty;
struct	tchars	sgchar, savechar;
struct	sgttyb	rs_arg;
#endif /* USE_OLD_DEVIO */

#define	COBUF_SZ	4096
static	uchar	cobuf[COBUF_SZ+256];
static	uchar	*co_ptr, *coe_ptr;

int	rs_fd;

#define	LIBUF_SZ	16384
static	uchar	libuf[LIBUF_SZ+1];
static	uchar	*libuf_p, *libuf_g, *libuf_e;
static	int	libuf_ovf;

#define system_on	system("stty cbreak -echo raw")
#define system_off	system("stty -cbreak echo -raw")

/*======================================================================*/
/*	tty  I/F							*/
/*======================================================================*/
/*------------------------------------------------------------*/
int	TYinit()
/*------------------------------------------------------------*/
{
	FILE	*ttyfp;

	/* set up raw for i/o for crt */
	if (ttyfp = fopen("/dev/tty", "r+")) {
		tty_fd = fileno(ttyfp);
#ifndef USE_OLD_DEVIO
		tcgetattr(tty_fd, &savetty);
		sgtty = savetty;
		sgtty.c_lflag &= ~(ICANON|ECHO);
		sgtty.c_cc[VMIN] = 0;
		sgtty.c_cc[VEOF] = 0;
		sgtty.c_iflag &= ~(INLCR|ICRNL|ISTRIP|IXON|BRKINT); 
		/* |IUCLC */
		sgtty.c_oflag &= ~(OPOST);
		tcsetattr(tty_fd, TCSADRAIN, &sgtty);
#else
		ioctl (tty_fd, TIOCGETP, &savetty);
		sgtty = savetty;
		sgtty.sg_flags |= (/*RAW |*/ CBREAK);
		sgtty.sg_flags &= ~(ECHO);
		ioctl (tty_fd, TIOCSETP, &sgtty);
		ioctl (tty_fd, TIOCGETC, &savechar);
		sgchar = savechar;
		sgchar.t_startc = 0;
		sgchar.t_stopc = 0;
		ioctl (tty_fd, TIOCSETC, &sgchar);
#endif /* USE_OLD_DEVIO */
		co_ptr = cobuf;
		coe_ptr = co_ptr + COBUF_SZ - 1;
		return (0);
	}
	return (1);
}
/*------------------------------------------------------------*/
void	TYflush()
/*------------------------------------------------------------*/
{
	uchar	*ptr;
	int	i, d_size;
	long	l;

	if (d_size = co_ptr - cobuf) {
/**/		rs_read();
		for( ptr = cobuf; d_size > 0 ; ptr += i, d_size -= i ) {
			if ((i = write(tty_fd, ptr, d_size)) < 0) break;
		}
	}
	co_ptr = cobuf;
}
/*------------------------------------------------------------*/
void	TYclr()
/*------------------------------------------------------------*/
{
	co_ptr = cobuf;
}
/*------------------------------------------------------------*/
void	TYout(uchar c)
/*------------------------------------------------------------*/
{
	if (c == '\n'){
		*co_ptr++ = CR;
		*co_ptr++ = c;	/* console is RAW mode */
		TYflush();
	} else {
		*co_ptr++ = c;
		if (co_ptr >= coe_ptr) TYflush(); /* care about overflow */
	}
}
/*------------------------------------------------------------*/
void	TYouts(uchar *s)
/*------------------------------------------------------------*/
{
	uchar	c;

	while (c = *s++) {
		if (c == '\n') *co_ptr++ = CR;	/* CR+LF, in this order */
		*co_ptr++ = c;
	}
	TYflush();
}
/*------------------------------------------------------------*/
uchar	TYin()
/*------------------------------------------------------------*/
{
	uchar	c;
	long	l;

/**/	rs_read();

	ioctl(tty_fd, FIONREAD, &l);
	return (l? (read(tty_fd, &c, 1) == 1 ? c : 0) : 0);
}
/*------------------------------------------------------------*/
int	Keytest(uchar c)
/*------------------------------------------------------------*/
{
	uchar	c1;
	int	i;

	if (c == ESC) {
		for (i = 0; i < 4 && (c1 = TYin()) == 0; i++) sleep_ms(50);
		if (c1 == '[') {
			for (i = 0; i < 4 && (c1 = TYin()) == 0; i++)
								sleep_ms(50);
			switch (c1) {
			case 'A': return (CUR_UP);
			case 'B': return (CUR_DWN);
			case 'C': return (CUR_FWD);
			case 'D': return (CUR_BWD);
			case '2':
				for (i = 0; (c1 = TYin()) != 'z';)
					if (c1) i = i * 10 + c1 - '0';
				if (i == 9)  return (CUR_UPx);
				if (i == 12) return (CUR_DWNx);
				if (i == 13) return (CUR_FWDx);
				if (i == 11) return (CUR_BWDx);
			}
			return (0);		/* ignore */
		}
	}
	return (c);
}
/*======================================================================*/
/*	RS232C	I/F							*/
/*======================================================================*/
/*------------------------------------------------------------*/
void	rs_reset_ptr()
/*------------------------------------------------------------*/
{
	libuf_p = libuf_g = libuf;
	libuf_e = libuf_p + LIBUF_SZ;
	libuf_ovf = 0;
}
/*------------------------------------------------------------*/
int	RSinit(uchar *line, int real_baud)
/*------------------------------------------------------------*/
{
	int	arg;
	int 	baud;

	switch (real_baud) {
	case 2400: baud = B2400; break;
	case 4800: baud = B4800; break;
	case 9600: baud = B9600; break;
	case 19200: default: baud = B19200; break;
	case 38400: baud = B38400; break;
	}

	rs_reset_ptr();		/* Reset pointers, buffer */

	if (line == NULL) line = (uchar*)DEF_LINE;

	if ((rs_fd = open(line, O_RDWR, 0777)) < 0) {
		fprintf(stderr,"RS232C open error\n");
		return (-1);
	}
#ifndef USE_OLD_DEVIO
	if (tcgetattr(rs_fd, &rs_arg) == -1) return (-1);

	cfsetospeed(&rs_arg, baud);
	cfsetispeed(&rs_arg, 0);
	rs_arg.c_cflag |= CRTSCTS | CS8 | CREAD;
	rs_arg.c_lflag = 0;
	rs_arg.c_cc[VTIME]    = 0;
	rs_arg.c_cc[VMIN]     = 1;
	rs_arg.c_iflag = IGNPAR;
	rs_arg.c_oflag = 0;
	tcflush(rs_fd, TCIFLUSH);
	if (tcsetattr(rs_fd, TCSANOW, &rs_arg) == -1) return (-1);
#else /* USE_OLD_DEVIO */
	if (ioctl(rs_fd, TIOCGETP, &rs_arg)) return (-1);
	rs_arg.sg_ispeed = rs_arg.sg_ospeed = baud;
	rs_arg.sg_flags |= (CBREAK | RAW /*| TANDEM*/);
	rs_arg.sg_flags &= ~(ECHO | TANDEM | CRMOD | ANYP);
	if (ioctl(rs_fd, TIOCSETP, &rs_arg)) return (-1);
#endif /* USE_OLD_DEVIO */
#if	0
	/******* Set interrupt vector *******/
	signal (SIGIO, rs_read);
	arg = fcntl(rs_fd, F_GETFL) | FASYNC;
	if (fcntl(rs_fd, F_SETFL, arg) == -1) return (-1);
	if (fcntl(rs_fd, F_SETOWN, getpid()) == -1) return (-1);
#endif
	return (0);	/* no error */
}
/*------------------------------------------------------------*/
void	RSclr()
/*------------------------------------------------------------*/
{
#ifndef USE_OLD_DEVIO
	tcflush(rs_fd, TCIOFLUSH);
#else
	ioctl(rs_fd, TIOCFLUSH);
#endif /* USE_OLD_DEVIO */
	rs_reset_ptr();
}
/*------------------------------------------------------------*/
void	rs_read()
/*------------------------------------------------------------*/
{
	int	buf_remain, read_count, size;
	int	len;

	ioctl(rs_fd, FIONREAD, &len);
	if (libuf_g > libuf_p) size = libuf_g - libuf_p - 1;
	else size = LIBUF_SZ - (libuf_p - libuf_g) - 1;

	if (size > len) {size = len; libuf_ovf = 0;}
	else if (libuf_ovf++ == 0) Puts("\n** RS OVERFLOW **\n");

	for (read_count = 0; size -= read_count; ) {
		if ((buf_remain = libuf_e - libuf_p) > size) {
			read_count = read(rs_fd, libuf_p, size);
			libuf_p += read_count;
		} else {
			read_count = read(rs_fd, libuf_p, buf_remain);
			if ((libuf_p += read_count) >= libuf_e)
					libuf_p = libuf;
		}
	}
}
/*------------------------------------------------------------*/
int	RSin()
/*------------------------------------------------------------*/
{
	uchar	c;

/**/	rs_read();

	if (libuf_g != libuf_p) {
		c = *libuf_g;
		if (++libuf_g >= libuf_e) libuf_g = libuf;
		return c;
	}
	return -1;
}
/*------------------------------------------------------------*/
void	RSout(uchar c)
/*------------------------------------------------------------*/
{
	while (write(rs_fd, &c, 1) != 1);
/**/	rs_read();
}
/*------------------------------------------------------------*/
void	RSoutx(uchar c)
/*------------------------------------------------------------*/
{
	while (write(rs_fd, &c, 1) != 1);
}
/*------------------------------------------------------------*/
void	RSwrite(uchar *buf, int len)
/*------------------------------------------------------------*/
{
	write(rs_fd, buf, len);
}
/*------------------------------------------------------------*/
int	PollRSTY()
/*------------------------------------------------------------*/
{
	fd_set	fdmask;
	int maxfd;

	if (libuf_p != libuf_g) return(0);

	FD_ZERO(&fdmask);
	FD_SET(rs_fd, &fdmask);
	FD_SET(tty_fd, &fdmask);

	TYflush();

	maxfd = rs_fd;
	if (maxfd < tty_fd) maxfd = tty_fd;

	select(maxfd + 1, &fdmask, NULL, NULL, NULL);

	if (FD_ISSET(rs_fd, &fdmask)) rs_read();

	return (FD_ISSET(tty_fd, &fdmask));
}
/*======================================================================*/
/*------------------------------------------------------------*/
void	cur_addr(int l, int c)
/*------------------------------------------------------------*/
{
	char	buf[20];

	sprintf(buf, "\033[%d;%dH", l + 1, c + 1);
	TYouts(buf);
}
#if 0 /* use standard library */
/*------------------------------------------------------------*/
void	getcwd(uchar *s, int l)
/*------------------------------------------------------------*/
{
	uchar	tmp[PATHMAX_SUN+1];

	getwd(tmp);
	if (strlen(tmp) < l) strcpy(s, tmp);
}
#endif
/*------------------------------------------------------------*/
int	escape()
/*------------------------------------------------------------*/
{
	int	er;
	char	*s;
extern	char	*getenv();

	Puts("<< break GTERM >>\n");
	s = getenv("SHELL");
	er = do_system(s ? s : "/bin/csh");
	Puts("<< resume GTERM >>\n");
	return er;
}
/*------------------------------------------------------------*/
void	sys_end(int i)
/*------------------------------------------------------------*/
{
	TYflush();
#ifndef USE_OLD_DEVIO
	tcsetattr(tty_fd, TCSADRAIN, &savetty);
#else
	ioctl(tty_fd, TIOCSETP, &savetty);
	ioctl(tty_fd, TIOCSETC, &savechar);
#endif /* USE_OLD_DEVIO */
	exit(i);
}
/*------------------------------------------------------------*/
void	TYreinit()
/*------------------------------------------------------------*/
{
#ifndef USE_OLD_DEVIO
	tcsetattr(tty_fd, TCSADRAIN, &sgtty);
#else
	ioctl(tty_fd, TIOCSETC, &sgchar);
	ioctl(tty_fd, TIOCSETP, &sgtty);
#endif /* USE_OLD_DEVIO */
}
/*------------------------------------------------------------*/
int	do_system(char *s)
/*------------------------------------------------------------*/
{
	int	er;

#ifndef USE_OLD_DEVIO
	tcsetattr(tty_fd, TCSADRAIN, &savetty);
#else
	ioctl(tty_fd, TIOCSETP, &savetty);
	ioctl(tty_fd, TIOCSETC, &savechar);
#endif /* USE_OLD_DEVIO */
	er = system (s);
	TYreinit();
	return (er);
}
/*------------------------------------------------------------*/
void	sleep_ms(int n)
/*------------------------------------------------------------*/
{
#if	0
	struct timeval	wait;

	if (n > 0) {
		wait.tv_sec  = n / 1000;
		wait.tv_usec = (n % 1000) * 1000;
		select (32, NULL, NULL, NULL, &wait);
	}
#else
	usleep (n * 1000);	/* 960826: add *1000 */
#endif
}
