/* -*- c++ -*-
 * Copyright (c) 2001 Personal Media Corporation. All rights reserved.
 */
#ifndef __bsupport_UnicodeMap_h___
#define __bsupport_UnicodeMap_h___
#include <stddef.h>

namespace bsupport
{
    class UnicodePrivateMap
    {
    public:
        enum UnicodeToEntityResult
        {
            eOK,
            eNoMapping,
            eBufferTooSmall
        };

        static UnicodePrivateMap* Create ();
        virtual void dispose () = 0;
        virtual int EntityToUnicode (const char* aEntity, size_t aLength,
                                     unsigned short& aUnichar) = 0;
        virtual UnicodeToEntityResult
        UnicodeToEntity (unsigned short aUnichar,
                         char* aEntity, size_t& aLength) = 0;
    };
}

#endif
