/* -*- c++ -*-
 * Copyright (c) 2001 Personal Media Corporation. All rights reserved.
 */
#ifndef __bsupport_UnicodeMapImpl_h___
#define __bsupport_UnicodeMapImpl_h___
#include "UnicodeMap.h"

#include <hash_map>

#include <basic.h>
#include <wtstring.h>

namespace bsupport
{
    class UMap : public UnicodePrivateMap
    {
    public:
        typedef unsigned short Unichar_t;

        UMap ();
        virtual ~UMap () {}

        static UMap* Create ();
        virtual void dispose ();
        virtual int EntityToUnicode (const char* aEntity,
                                     size_t aLength,
                                     Unichar_t& aUnichar);
        virtual UnicodeToEntityResult
        UnicodeToEntity (Unichar_t aUnichar,
                         char* aEntity, size_t& aLength);
        virtual int UnicodeToWtc (Unichar_t aUnichar, WTC& aWtc);
        virtual int WtcToUnicode (WTC aWtc, Unichar_t& aUnichar);
        virtual bool LookupByWtc (WTC aWtc, Unichar_t& aUnichar);

    protected:
        int EntityToWtc (const char* aEntity, WTC& aWtc) const;

    private:
        typedef std::hash_map<WTC, Unichar_t> WtcToUniMap;
        typedef std::hash_map<Unichar_t, WTC> UniToWtcMap;

        static const Unichar_t MinUnichar = 0xe000;
        static const Unichar_t MaxUnichar = 0xf8ff;
        static const size_t EntityLength = 7;

        Unichar_t index_;
        WtcToUniMap touni_;
        UniToWtcMap towtc_;
    };
}


#endif
// Local Variables:
// c-file-style: "stroustrup"
// End:
