/*
 * Copyright (c) 2001 Personal Media Corporation. All rights reserved.
 */

#ifndef _BTK_COLOR_H_
#define _BTK_COLOR_H_
#include "btron/dp.h"

namespace BToolkit {
namespace ColorDef {
    static const COLOR RGBMask = 0x10000000;
    static const COLOR ColorMask = 0x000000ff;
    static const int RedShift = 16;
    static const int GreenShift = 8;
    static const int BlueShift = 0;
} // namespace ColorDef

namespace ColorOp {

inline
int
GetR(COLOR c)
{
    return (c >> ColorDef::RedShift) & ColorDef::ColorMask;
}

inline
int
GetG(COLOR c)
{
    return (c >> ColorDef::GreenShift) & ColorDef::ColorMask;
}

inline
int
GetB(COLOR c)
{
    return (c >> ColorDef::BlueShift) & ColorDef::ColorMask;
}

inline
COLOR
Compose(int r, int g, int b)
{
    return COLOR(ColorDef::RGBMask
                 | ((r & ColorDef::ColorMask) << ColorDef::RedShift)
                 | ((g & ColorDef::ColorMask) << ColorDef::GreenShift)
                 | ((b & ColorDef::ColorMask) << ColorDef::BlueShift));
}

inline
void
Decompose(COLOR c, int& r, int& g, int& b)
{
    r = GetR(c);
    g = GetG(c);
    b = GetB(c);
}

} // namespace ColorOp
} // namespace BToolkit

#endif
// Local Variables:
// mode: C++
// c-file-style: "stroustrup"
// End:
