/*
 * Copyright (c) 1999 Personal Media Corporation. All rights reserved.
 */
#ifndef bsllocale_h___
#define bsllocale_h___
#include <sys/cdefs.h>

struct lconv {
        char    *decimal_point;
        char    *thousands_sep;
        char    *grouping;
        char    *int_curr_symbol;
        char    *currency_symbol;
        char    *mon_decimal_point;
        char    *mon_thousands_sep;
        char    *mon_grouping;
        char    *positive_sign;
        char    *negative_sign;
        char    int_frac_digits;
        char    frac_digits;
        char    p_cs_precedes;
        char    p_sep_by_space;
        char    n_cs_precedes;
        char    n_sep_by_space;
        char    p_sign_posn;
        char    n_sign_posn;
};

#define LC_CTYPE        0
#define LC_NUMERIC      1
#define LC_TIME         2
#define LC_COLLATE      3
#define LC_MONETARY     4
#define LC_MESSAGES     5
#define LC_ALL          6

__BEGIN_DECLS
char*         setlocale __P((int category, const char *locale));
struct lconv* localeconv __P((void));
__END_DECLS

#endif
