/* -*- c++ -*- */
#ifndef Base64_h___
#define Base64_h___
#include <sys/cdefs.h>
#ifdef __cplusplus
#include <algorithm>
#endif


/* src ΥХ base64󥳡ɤ enc ˳Ǽ롣
   enc Υ src Ĺcharñ̡src_len Фơ
   (src_len + 2)/3*4 Ĺcharñ̡ˤɬפǤ롣
   ̤ΥХϾ˽üʤǡΤѴ̤Τ
   Ǽ롣
   ͤϡѴ̤ΥХĹcharñ̡ˤǤ롣
   src Х '\0'NULLˤޤ⡢src_len
   ХȤ٤Ѵ롣
*/
__BEGIN_DECLS
size_t	base64encode	(char * enc, const void * src, size_t src_len);
size_t	base64decode	(void * dec, const char * src, size_t src_len);
__END_DECLS


#ifdef __cplusplus
class Base64
{
public:
  // Base64르ꥺˤХѴ
  // Ѵޥåסѥǥʸꤹ뤳ȤǤ롣
  // ǥեѴޥåפ
  // "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/"
  // ǥեȥѥǥʸ '='
  // map ˥ѥǥʸޤƤϤʤʤ
  // map  64ХȰʾɬסǽ64ХȤΤͭ
  Base64 (const char* map = 0, char padding = 0);

  void SetMap (const char* map);
  void SetPadding (char c);

  size_t Encode (char* enc, const void* src, size_t src_len) const;
  size_t Decode (void* dec, const char* src, size_t src_len) const;

  template <class I, class J>
  void encode (I begin, I end, J out) const
  {
    (void) base64encode (begin, end, map_, pad_, out);
  }

  template <class I, class J>
  void decode (I begin, I end, J out) const
  {
    (void) base64decode (begin, end, rmap_, pad_, out);
  }

public:
  template <class I, class J>
  static
  J base64encode (I p, I p_end, const char* table, const char padding, J o)
  {
    unsigned int c1, c2, c3;

    while (p != p_end) {
      c1 = *p; ++p;
      if (p != p_end) {
        c2 = *p; ++p;
        if (p != p_end) {
          c3 = *p; ++p;
          o = compose (c1, c2, c3, 0, table, padding, o);
        } else {
          o = compose (c1, c2, 0, 1, table, padding, o);
          break;
        }
      } else {
        o = compose (c1, 0, 0, 2, table, padding, o);
        break;
      }
    }
    return o;
  }

  static char base64 (unsigned int c, const char* table)
  {
    return table [c & 0x3F];
  }

  template <class I>
  static I
  compose (unsigned int c1, unsigned int c2, unsigned int c3,
           int padding, const char* enc_table, const char pad,
           I o)
  {
    *o = base64 (c1 >> 2, enc_table); ++o;
    *o = base64 (((c1 & 0x3) << 4) | ((c2 & 0xF0) >> 4), enc_table); ++o;
    switch (padding) {
    case 0:
      *o = base64 (((c2 & 0xF) << 2) | ((c3 & 0xC0) >> 6), enc_table);
      ++o;
      *o = base64 (c3 & 0x3F, enc_table);
      ++o;
      break;
    case 1:
      *o = base64(((c2 & 0xF) << 2) | ((c3 & 0xC0) >> 6), enc_table);
      ++o;
      *o = pad; ++o;
      break;
    case 2:
      *o = pad; ++o;
      *o = pad; ++o;
      break;
    }
    return o;
  }

  template <class I, class J>
  static
  J base64decode (I s, I s_end, const int* table, const char padding, J ptr)
  {
    int c1 = -1, c2 = -1, c3 = -1, c4;

    while (s != s_end) {
      if (*s == '\r' || *s == '\n') { ++s; continue; }
      if ((c1 = table[*s]) == -1) break;
      if (s + 1 == s_end) break;
      if ((c2 = table[*(s + 1)]) == -1) break;
      if (s + 2 == s_end) break;
      if ((c3 = table[*(s + 2)]) == -1) break;
      if (s + 3 == s_end) break;
      if ((c4 = table[*(s + 3)]) == -1) break;
      *ptr = (c1 << 2 | c2 >> 4); ++ptr;
      *ptr = (c2 << 4 | c3 >> 2); ++ptr;
      *ptr = (c3 << 6 | c4);      ++ptr;
      std::advance (s, 4);
    }
    if (s + 2 < s_end)
      if (c1 != -1 && c2 != -1 && *(s + 2) == padding) {
        *ptr = c1 << 2 | c2 >> 4; ++ptr;
      }
    if (s + 3 < s_end)
      if (c1 != -1 && c2 != -1 && c3 != -1 && *(s + 3) == padding) {
        *ptr = c1 << 2 | c2 >> 4; ++ptr;
        *ptr = c2 << 4 | c3 >> 2; ++ptr;
      }
    return ptr;
  }

private:
  char map_ [64];
  char pad_;
  int rmap_ [256];
};
#endif


#endif
