#ifndef UnicodeConv_h___
#define UnicodeConv_h___
#include <stddef.h>
#include <sys/cdefs.h>
#include <typedef.h>

__BEGIN_DECLS


/*
// UTF-8 -> TC
// src Cʸ(NULLüUTF-8󥳡)TCѴ
// dst ˳Ǽ롣( (size - 1)ʸ + TNULLü)
// dst ϾTNULLü롣(size == 0 ξ)
// dst Υ(TNULLüޤ) size ǻꤹ롣
// Ѵ̤Ȥƽ񤭹⤦Ȥ(TNULLüޤޤʤ)֤
// size <=  ξ硢񤭹ޤʤäʸ뤳Ȥ򼨤
*/

size_t
str_utf8totc(TC* dst, const char* src, size_t size);


/*
// TC -> UTF-8
// src TCʸ(TNULLü䵤ʤ)UTF-8Ѵ
// dst ˳Ǽ롣( (size - 1)ʸ + NULLü)
// dst ϾNULLü롣(size == 0 ξ)
// dst Υ(NULLüޤ) size ǻꤹ롣
// Ѵ̤Ȥƽ񤭹⤦Ȥ(NULLüޤޤʤ)֤
// size <=  ξ硢񤭹ޤʤäʸ뤳Ȥ򼨤
*/

size_t
str_tctoutf8(char* dst, const TC* src, size_t size);


// ASCII -> TC
// str_utf8totc  ASCII С7ӥåASCIIϰϤΤ
// Ѵ롣

size_t
strlcpy_a2t(TC* dst, const char* src, size_t size);


__END_DECLS
#endif
