/*
 * Copyright (c) 1999 Personal Media Corporation. All rights reserved.
 */
#ifndef brv__b_thread_h___
#define brv__b_thread_h___
#include <sys/types.h>
#include <qt.h>
__BEGIN_DECLS

#define BT_CREATE  QT_ARGS
#define BT_SWITCH  QT_BLOCK
#define BT_STKALIGN(sp) \
  ((void *)((((qt_word_t)(sp)) + (QT_STKALIGN) - 1) & ~((QT_STKALIGN)-1)))
#define BT_SP(s, size) \
  QT_SP(BT_STKALIGN(s), (size) - QT_STKALIGN)

typedef struct BThread BThread;
typedef struct BThreadQue BThreadQue;
typedef qt_userf_t BThreadFunc;
typedef qt_t* BThreadSP;

struct BThread {
  BThreadSP sp;
  int save_errno;
  void* stack;
  BThread* next;
};

__END_DECLS

#if 0
struct BThreadQue {
  BThread t;
  BThread* tail;
};


Inline
void BThreadQue_init(BThreadQue* q)
{
  q->t.next = q->tail = &q->t;
}

Inline
BThread* BThreadQue_get(BThreadQue* q)
{
  BThread* t;

  t = q->t.next;
  q->t.next = t->next;
  if (t->next == &q->t) {
    if (t == &q->t) {		/* If it was already empty .. */
      return NULL;
    }
    q->tail = &q->t;		/* Else now it is empty. */
  }
  return t;
}

Inline
void BThreadQue_put(BThreadQue* q, BThread* t)
{
  q->tail->next = t;
  t->next = &q->t;
  q->tail = t;
}
#endif /* 0 */

#endif
