/*
 * Copyright (c) 2001 Personal Media Corporation. All rights reserved.
 */

#ifndef _BTK_IC_H_
#define _BTK_IC_H_
#include <utility>
#include "btron/tip.h"
#include "btkfwd.h"

namespace BToolkit {

    // Input Context
    class BtkIc
    {
    public:
        virtual ~BtkIc () {}
        static BtkIc* makeIc();

        virtual void dispose() = 0;
        virtual void begin(Component*) = 0;
        virtual void end() = 0;
        virtual bool handleEvent(const EVENT&) = 0;
        virtual bool remains() = 0;
        virtual bool flush() = 0;

        enum CallbackType {
            ePreeditStart,
            ePreeditDraw,
            ePreeditDone
        };
        typedef int (*CallbackProc)(BtkIc*, void* clientData, int tipsts, const TIPREC& tiprec);

        typedef std::pair<CallbackProc, void*> CallbackValue;
        virtual CallbackValue setCallback(CallbackType, CallbackProc, void* clientData) = 0;
    };

} // namespace BToolkit

#endif
// Local Variables:
// mode: C++
// c-file-style: "stroustrup"
// End:
