/*
 * Copyright (c) 2001 Personal Media Corporation. All rights reserved.
 */

#ifndef _BTK_TCODE_H_
#define _BTK_TCODE_H_

#include <tcode.h>
#if defined(__BRIGHTV__)
#include <keycode.h>
#elif defined(__TENGINE__)
#include <device/keycode.h>
#endif


namespace BToolkit
{

namespace btk_keysym
{
    static const long BTK_ENTER      = KC_NL;
    static const long BTK_BACK_SPACE = KC_BS;
    static const long BTK_TAB        = KC_TAB;
    static const long BTK_CANCEL     = 0x0003;
    static const long BTK_CLEAR      = 0x000c;
    static const long BTK_SHIFT      = 0;
    static const long BTK_CONTROL    = 0;
    static const long BTK_ALT        = 0;
    static const long BTK_PAUSE      = 0;
    static const long BTK_CAPS_LOCK  = 0;
    static const long BTK_ESCAPE     = KC_CAN;
    static const long BTK_SPACE      = TK_KSP;
    static const long BTK_SPACE1     = 0x0020;
    static const long BTK_SPACE2     = 0x00a0;
    static const long BTK_PAGE_UP    = KC_PG_U;
    static const long BTK_PAGE_DOWN  = KC_PG_D;
    static const long BTK_END        = KC_END;
    static const long BTK_HOME       = KC_HOME;
    static const long BTK_LEFT       = KC_CC_L;
    static const long BTK_UP         = KC_CC_U;
    static const long BTK_RIGHT      = KC_CC_R;
    static const long BTK_DOWN       = KC_CC_D;
    static const long BTK_COMMA      = TK_CMMA;
    static const long BTK_PERIOD     = TK_PROD;
    static const long BTK_SLASH      = TK_SLSH;

    static const long BTK_0          = TK_0;
    static const long BTK_1          = TK_1;
    static const long BTK_2          = TK_2;
    static const long BTK_3          = TK_3;
    static const long BTK_4          = TK_4;
    static const long BTK_5          = TK_5;
    static const long BTK_6          = TK_6;
    static const long BTK_7          = TK_7;
    static const long BTK_8          = TK_8;
    static const long BTK_9          = TK_9;

    static const long BTK_SEMICOLON  = TK_SCLN;
    static const long BTK_EQUALS     = TK_EQAL;

    static const long BTK_a          = TK_a;
    static const long BTK_b          = TK_b;
    static const long BTK_c          = TK_c;
    static const long BTK_d          = TK_d;
    static const long BTK_e          = TK_e;
    static const long BTK_f          = TK_f;
    static const long BTK_g          = TK_g;
    static const long BTK_h          = TK_h;
    static const long BTK_i          = TK_i;
    static const long BTK_j          = TK_j;
    static const long BTK_k          = TK_k;
    static const long BTK_l          = TK_l;
    static const long BTK_m          = TK_m;
    static const long BTK_n          = TK_n;
    static const long BTK_o          = TK_o;
    static const long BTK_p          = TK_p;
    static const long BTK_q          = TK_q;
    static const long BTK_r          = TK_r;
    static const long BTK_s          = TK_s;
    static const long BTK_t          = TK_t;
    static const long BTK_u          = TK_u;
    static const long BTK_v          = TK_v;
    static const long BTK_w          = TK_w;
    static const long BTK_x          = TK_x;
    static const long BTK_y          = TK_y;
    static const long BTK_z          = TK_z;

    static const long BTK_A          = TK_A;
    static const long BTK_B          = TK_B;
    static const long BTK_C          = TK_C;
    static const long BTK_D          = TK_D;
    static const long BTK_E          = TK_E;
    static const long BTK_F          = TK_F;
    static const long BTK_G          = TK_G;
    static const long BTK_H          = TK_H;
    static const long BTK_I          = TK_I;
    static const long BTK_J          = TK_J;
    static const long BTK_K          = TK_K;
    static const long BTK_L          = TK_L;
    static const long BTK_M          = TK_M;
    static const long BTK_N          = TK_N;
    static const long BTK_O          = TK_O;
    static const long BTK_P          = TK_P;
    static const long BTK_Q          = TK_Q;
    static const long BTK_R          = TK_R;
    static const long BTK_S          = TK_S;
    static const long BTK_T          = TK_T;
    static const long BTK_U          = TK_U;
    static const long BTK_V          = TK_V;
    static const long BTK_W          = TK_W;
    static const long BTK_X          = TK_X;
    static const long BTK_Y          = TK_Y;
    static const long BTK_Z          = TK_Z;

    static const long BTK_OPEN_BRACKET = TK_LABR;
    static const long BTK_BACK_SLASH = TK_BSLH;
    static const long BTK_CLOSE_BRACKET = TK_RABR;

    static const long BTK_NUMPAD0    = 0;
    static const long BTK_NUMPAD1    = 0;
    static const long BTK_NUMPAD2    = 0;
    static const long BTK_NUMPAD3    = 0;
    static const long BTK_NUMPAD4    = 0;
    static const long BTK_NUMPAD5    = 0;
    static const long BTK_NUMPAD6    = 0;
    static const long BTK_NUMPAD7    = 0;
    static const long BTK_NUMPAD8    = 0;
    static const long BTK_NUMPAD9    = 0;
    static const long BTK_MULTIPLY   = 0;
    static const long BTK_ADD        = 0;
    static const long BTK_SEPARATOR  = 0;
    static const long BTK_SUBTRACT   = 0;
    static const long BTK_DECIMAL    = 0;
    static const long BTK_DIVIDE     = 0;

    static const long BTK_F1         = KC_PF1;
    static const long BTK_F2         = KC_PF2;
    static const long BTK_F3         = KC_PF3;
    static const long BTK_F4         = KC_PF4;
    static const long BTK_F5         = KC_PF5;
    static const long BTK_F6         = KC_PF6;
    static const long BTK_F7         = KC_PF7;
    static const long BTK_F8         = KC_PF8;
    static const long BTK_F9         = KC_PF9; // not fired by B-right/V
    static const long BTK_F10        = KC_PF10;// not fired by B-right/V
    static const long BTK_F11        = KC_PF11;
    static const long BTK_F12        = KC_PF12;// not fired by B-right/V

    static const long BTK_DELETE     = KC_DEL;
    static const long BTK_NUM_LOCK   = 0;
    static const long BTK_SCROLL_LOCK = 0;

    static const long BTK_PRINTSCREEN = 0;
    static const long BTK_INSERT     = 0;
    static const long BTK_HELP       = 0;
    static const long BTK_META       = 0;

    static const long BTK_BACK_QUOTE = TK_RQOT;
    static const long BTK_QUOTE      = TK_SQOT;

    static const long BTK_FINAL      = 0;
    static const long BTK_CONVERT    = KC_CNV;
    static const long BTK_NONCONVERT = KC_CNV0;
    static const long BTK_ACCEPT     = 0;
    static const long BTK_MODECHANGE = 0;
    static const long BTK_KANA       = 0;
    static const long BTK_KANJI      = 0;

    // sub CC key (converted to Alt + main CC key)
    static const long BTK_SUB_LEFT     = KC_SC_L;
    static const long BTK_SUB_RIGHT    = KC_SC_R;
    static const long BTK_SUB_UP       = KC_SC_U;
    static const long BTK_SUB_DOWN     = KC_SC_D;

    // for mouse wheel. left, right scroll is not supported.
    static const long BTK_SCROLL_UP    = KC_SS_U;
    static const long BTK_SCROLL_DOWN  = KC_SS_D;
}

} // namespace BToolkit

#endif
// Local Variables:
// mode: C++
// c-file-style: "stroustrup"
// End:
