/* mips.s -- assembly support. */

/*
 * QuickThreads -- Threads-building toolkit.
 * Copyright (c) 1993 by David Keppel
 * Copyright (c) 2003 by Personal Media Corporation
 *
 * Permission to use, copy, modify and distribute this software and
 * its documentation for any purpose and without fee is hereby
 * granted, provided that the above copyright notice and this notice
 * appear in all copies.  This software is provided as a
 * proof-of-concept and for demonstration purposes; there is no
 * representation about the suitability of this software for any
 * purpose.
 */

/* Callee-save $16-$23, $30-$31.
 *
 * On startup, restore regs so retpc === call to a function to start.
 * We're going to call a function ($4) from within this routine.
 * We're passing 3 args, therefore need to allocate 24 extra bytes on
 * the stack for a save area.  The start routine needs a like 32-byte
 * save area.  Must be doubleword aligned.
 */

	.globl qt_block
	.globl qt_blocki
	.globl qt_abort
	.globl qt_start
	.globl qt_vstart

	/*
	** $4: ptr to function to call once curr is suspended
	**	and control is on $7's stack.
	** $5: 1'th arg to $4.
	** $6: 2'th arg to $4
	** $7: sp of thread to suspend.
	**
	** Totally gross hack: The MIPS calling convention reserves
	** 4 words on the stack for a0..a3.  This routine "ought" to
	** allocate space for callee-save registers plus 4 words for
	** the helper function, but instead we use the 4 words
	** provided by the function that called us (we don't need to
	** save our argument registers).  So what *appears* to be
	** allocating only 80 bytes is actually allocating 112, by
	** using the caller's 32 bytes.
	**
	** The helper routine returns a value that is passed on as the
	** return value from the blocking routine.  Since we don't
	** touch $2 between the helper's return and the end of
	** function, we get this behavior for free.
	*/
qt_blocki:
	subu	$sp, $sp, 10*8	/* Allocate reg save space. */
	sd	$16,  4*8($sp)
	sd	$17,  5*8($sp)
	sd	$18,  6*8($sp)
	sd	$19,  7*8($sp)
	sd	$20,  8*8($sp)
	sd	$21,  9*8($sp)
	sd	$22, 10*8($sp)
	sd	$23, 11*8($sp)
	sd	$30, 12*8($sp)
	sd	$31, 13*8($sp)
qt_abort:
	move	$2, $sp		/* $2 <= old sp to pass to func@$4. */
	move	$sp, $7		/* $sp <= new sp. */
	.set noreorder
	jal	$4		/* Call helper func@$4 . */
	move	$4, $2		/* $a0 <= pass old sp as a parameter. */
	.set reorder

	ld	$31, 13*8($sp)	/* Restore callee-save regs... */
	ld	$30, 12*8($sp)
	ld	$23, 11*8($sp)
	ld	$22, 10*8($sp)
	ld	$21,  9*8($sp)
	ld	$20,  8*8($sp)
	ld	$19,  7*8($sp)
	ld	$18,  6*8($sp)
	ld	$17,  5*8($sp)
	ld	$16,  4*8($sp)	/* Restore callee-save */

	addu	$sp, $sp, 10*8	/* Deallocate reg save space. */
	j	$31		/* Return to caller. */

	/*
	** Non-varargs thread startup.
	** Note: originally, 112 bytes were allocated on the stack.
	** The thread restore routine (_blocki/_abort) removed 80
	** of them, which means there is still 32 bytes for the
	** argument area required by the MIPS calling convention.
	*/
qt_start:
	move	$4, $16		/* Load up user function pu. */
	move	$5, $17		/* ... user function pt. */
	move	$6, $18		/* ... user function userf. */
	jal	$19		/* Call `only'. */
	j	qt_error


	/*
	** Save calle-save floating-point regs $f20-$f31
	** See comment in `qt_block' about calling conventinos and
	** reserved space.  Use the same trick here, but here we
	** actually have to allocate all the bytes since we have to
	** leave 4 words leftover for `qt_blocki'.
	**
	** Return value from `qt_block' is the same as the return from
	** `qt_blocki'.  We get that for free since we don't touch $2
	** between the return from `qt_blocki' and the return from
	** `qt_block'.
	*/
qt_block:
	subu	$sp, $sp, 13*8
	sd	$31,   4*8($sp)
	sdc1	$f20,  5*8($sp)
	sdc1	$f21,  6*8($sp)
	sdc1	$f22,  7*8($sp)
	sdc1	$f23,  8*8($sp)
	sdc1	$f24,  9*8($sp)
	sdc1	$f25, 10*8($sp)
	sdc1	$f26, 11*8($sp)
	sdc1	$f27, 12*8($sp)
	sdc1	$f28, 13*8($sp)
	sdc1	$f29, 14*8($sp)
	sdc1	$f30, 15*8($sp)
	sdc1	$f31, 16*8($sp)

	jal	qt_blocki

	ldc1	$f31, 16*8($sp)
	ldc1	$f30, 15*8($sp)
	ldc1	$f29, 14*8($sp)
	ldc1	$f28, 13*8($sp)
	ldc1	$f27, 12*8($sp)
	ldc1	$f26, 11*8($sp)
	ldc1	$f25, 10*8($sp)
	ldc1	$f24,  9*8($sp)
	ldc1	$f23,  8*8($sp)
	ldc1	$f22,  7*8($sp)
	ldc1	$f21,  6*8($sp)
	ldc1	$f20,  5*8($sp)
	ld	$31,   4*8($sp)
	addu	$sp, $sp, 13*8
	j	$31


	/*
	** First, call `startup' with the `pt' argument.
	**
	** Next, call the user's function with all arguments.
	** Note that we don't know whether args were passed in
	** integer regs, fp regs, or on the stack (See Gerry Kane
	** "MIPS R2000 RISC Architecture" pg D-22), so we reload
	** all the registers, possibly with garbage arguments.
	**
	** Finally, call `cleanup' with the `pt' argument and with
	** the return value from the user's function.  It is an error
	** for `cleanup' to return.
	*/
qt_vstart:
	move	$4, $17		/* `pt' is arg0 to `startup'. */
	jal	$18		/* Call `startup'. */

	addu	$sp, $sp, 4*8	/* Free extra save space. */
	ld	$4, 0*8($sp)	/* Load up args. */
	ld	$5, 1*8($sp)
	ld	$6, 2*8($sp)
	ld	$7, 3*8($sp)
	ldc1	$f12, 0*8($sp)	/* Load up fp args. (double Τߤб) */
	ldc1	$f13, 1*8($sp)
	jal	$19		/* Call `userf'. */

	move	$4, $17		/* `pt' is arg0 to `cleanup'. */
	move	$5, $2		/* Ret. val is arg1 to `cleanup'. */
	jal	$16		/* Call `cleanup'. */

	j	qt_error
