/*
 * QuickThreads -- Threads-building toolkit.
 * Copyright (c) 1993 by David Keppel
 * Copyright (c) 2003 by Personal Media Corporation
 *
 * Permission to use, copy, modify and distribute this software and
 * its documentation for any purpose and without fee is hereby
 * granted, provided that the above copyright notice and this notice
 * appear in all copies.  This software is provided as a
 * proof-of-concept and for demonstration purposes; there is no
 * representation about the suitability of this software for any
 * purpose.
 */

#ifndef QT_SH_H
#define QT_SH_H

typedef unsigned long qt_word_t;

#define QT_GROW_DOWN

/*
 * ѰбˤĤ
 *	FPU 쥸ˤϤѤ SH_FPU_VARGS = 1 Ȥ롣
 *	SH ΰϤʣʤᡢFPU 쥸ȤʤƤ QuickThreads 
 *	ǽϤȤϺFPU 쥸ȤФʣ
 *	Ȥʤ롣
 *	QuickThreads εǽϰϤǳʤϤΤϡint ޤϥݥ
 *	Τߤȹͤۤ褤ξ⡢쥸ϤȤʤդ
 *	ɬפ롣
 *	(SH_FPU_VARGS ѹϡsh.s  C ץץå̤Ƥʤ
 *	ᡢʬΥȤưԽ뤳)
 */
#define	SH_FPU_VARGS	0

/* Stack layout on the mips:

   Callee-save registers are: r8..r14, gbr, and also save pr.

   Non-varargs:

   +---		qt_block (FPU б) ξΤ FPU 쥸¸
   | fr15	FPU ΥХ󥯥쥸ˤб(setjmp Ʊ)
   | fr14
   | fr13
   | fr12
   | pr		qt_block ξΥåɤμ¹ԺƳɥ쥹
   +---		qt_blocki (FPU б) ξϤʹߤΤ
   | gbr
   | pr		qt_blocki ξΥåɤμ¹ԺƳɥ쥹
   | r14
   | r13
   | r12
   | r11	on startup === only
   | r10	on startup === userf
   | r9		on startup === pt
   | r8		on startup === pu	<--- sp
   +---

   Varargs:

   +---
   | args ...	userf() ϤѰ
   | r7		Υ쥸Ϥʬ
   | r6
   | r5
   | r4
#if SH_FPU_VARGS
   | fr10	(ȥ륨ǥ)
   | fr11
   | fr8
   | fr9
   | fr6
   | fr7
   | fr4
   | fr5
#endif
   +---
   | fr15	åɵư FPU 쥸ʬϤʤ
   | fr14
   | fr13
   | fr12
   | pr
   +---
   | gbr
   | pr
   | r14
   | r13
   | r12
   | r11	on startup === userf
   | r10	on startup === startup
   | r9		on startup === pt
   | r8		on startup === cleanup	<--- sp
   +---
*/

/* Stack must be doubleword aligned. */
#define QT_STKALIGN	(8)	/* Doubleword aligned. */

/* How much space is allocated to hold all the crud for initialization */
#define QT_STKBASE	(9 * 4)
#define QT_VSTKBASE	QT_STKBASE

/* Offsets of various registers. */
#define QT_PR	(7)
#define QT_R11	(3)
#define QT_R10	(2)
#define QT_R9	(1)
#define QT_R8	(0)

/* When a never-before-run thread is restored, the return pc points
   to a fragment of code that starts the thread running.  For
   non-vargs functions, it just calls the client's `only' function.
   For varargs functions, it calls the startup, user, and cleanup
   functions. */

extern void qt_start(void);
#define QT_ARGS_MD(sp)	(QT_SPUT (sp, QT_PR, qt_start))

#define QT_VARGS_MD0(sp, vabytes) \
  ((qt_t *)(((char *)(sp)) - QT_STKROUNDUP(((vabytes) < 4*4)? 4*4:(vabytes))))

extern void qt_vstart(void);
#define QT_VARGS_MD1(sp)	(QT_SPUT (sp, QT_PR, qt_vstart))

#define QT_VARGS_DEFAULT


/* The *index* (positive offset) of where to put each value. */
#define QT_ONLY_INDEX	(QT_R11)
#define QT_USER_INDEX	(QT_R10)
#define QT_ARGT_INDEX	(QT_R9)
#define QT_ARGU_INDEX	(QT_R8)

#define QT_VCLEANUP_INDEX	(QT_R8)
#define QT_VUSERF_INDEX		(QT_R11)
#define QT_VSTARTUP_INDEX	(QT_R10)
#define QT_VARGT_INDEX		(QT_R9)

#endif /* ndef QT_SH_H */
