/* sh.s -- SuperH assembly support. */

/*
 * QuickThreads -- Threads-building toolkit.
 * Copyright (c) 1993 by David Keppel
 * Copyright (c) 2003 by Personal Media Corporation
 *
 * Permission to use, copy, modify and distribute this software and
 * its documentation for any purpose and without fee is hereby
 * granted, provided that the above copyright notice and this notice
 * appear in all copies.  This software is provided as a
 * proof-of-concept and for demonstration purposes; there is no
 * representation about the suitability of this software for any
 * purpose.
 */

	.globl qt_block
	.globl qt_blocki
	.globl qt_abort
	.globl qt_start
	.globl qt_vstart

	.balign	2

/*
 * FPU бΥå
 *	void* qt_blocki( qt_helper_t *h, void *a0, void *a1, qt_t *newthread )
 *	void  qt_abort( qt_helper_t *h, void *a0, void *a1, qt_t *newthread )
 *
 *	qt_abort ϥåɤλ(쥸¸)
 *
 *	void* qt_helper( qt_t *old, void *a0, void *a1 )
 */
qt_blocki:
	stc.l	gbr, @-r15	/* 쥹åɤΥ쥸¸ */
	sts.l	pr,  @-r15
	mov.l	r14, @-r15
	mov.l	r13, @-r15
	mov.l	r12, @-r15
	mov.l	r11, @-r15
	mov.l	r10, @-r15
	mov.l	r9,  @-r15
	mov.l	r8,  @-r15
qt_abort:
	mov	r15, r0		/* r0 =  sp ¸ */
	mov	r7, r15		/* å */
	jsr	@r4		/* call helper(old, a0, a1) */
	mov	r0, r4		/* old:  sp */

	mov.l	@r15+, r8	/* åɤΥ쥸 */
	mov.l	@r15+, r9
	mov.l	@r15+, r10
	mov.l	@r15+, r11
	mov.l	@r15+, r12
	mov.l	@r15+, r13
	mov.l	@r15+, r14
	lds.l	@r15+, pr
	rts
	ldc.l	@r15+, gbr

/*
 * FPU бå
 *	void* qt_block( qt_helper_t *h, void *a0, void *a1, qt_t *newthread )
 */
qt_block:
	fmov.s	fr15, @-r15	/* 쥹åɤ FPU 쥸¸ */
	fmov.s	fr14, @-r15
	fmov.s	fr13, @-r15
	fmov.s	fr12, @-r15
	sts.l	pr, @-r15

	bsr	qt_blocki	/* FPU ʤåؤ˰Ѥ */
	nop

	lds.l	@r15+, pr	/* åɤ FPU 쥸 */
	fmov.s	@r15+, fr12
	fmov.s	@r15+, fr13
	fmov.s	@r15+, fr14
	rts
	fmov.s	@r15+, fr15

/*
 * ξΥåɤεư
 *	r11 = only
 *	r10 = userf
 *	r9  = pt
 *	r8  = pu
 *
 *	void only( void *pu, void *pt, qt_userf_t *userf )
 */
qt_start:
	mov	r8, r4		/* pu */
	mov	r9, r5		/* pt */
	jsr	@r11		/* call only(pu, pt, userf) */
	mov	r10, r6		/* userf */
				/* only() ʤϤ */
	mov.l	L_qt_error, r1
	jmp	@r1
	nop

/*
 * ѰξΥåɤεư
 *	r11 = userf
 *	r10 = startup
 *	r9  = pt
 *	r8  = cleanup
 *
 *	void startup( void *pt )
 *	void cleanup( void *pt, void *vuserf_return )
 */
qt_vstart:
	jsr	@r10		/* call startup(pt) */
	mov	r9, r4		/* pt */

#if SH_FPU_VARGS /* C ץץå̤ƤʤΤǡưǥȤԽ */
#	fmov.s	@r15+, fr5	/* userf() Ϥ쥸˳Ǽ */
#	fmov.s	@r15+, fr4
#	fmov.s	@r15+, fr7
#	fmov.s	@r15+, fr6
#	fmov.s	@r15+, fr9
#	fmov.s	@r15+, fr8
#	fmov.s	@r15+, fr11
#	fmov.s	@r15+, fr10
#endif
	mov.l	@r15+, r4
	mov.l	@r15+, r5
	mov.l	@r15+, r6
	jsr	@r11		/* call userf(...) */
	mov.l	@r15+, r7

	mov	r0, r5		/* userf()  */
	jsr	@r8		/* call cleanup(pt, userf()) */
	mov	r9, r4		/* pt */
				/* cleanup() ʤϤ */
	mov.l	L_qt_error, r1
	jmp	@r1
	nop

		.balign	4
  L_qt_error:	.long	qt_error
