#! /usr/bin/env perl

my $MOZILLA_INSTALLPATH=$ARGV[0];
my $installedChromeFile = "$MOZILLA_INSTALLPATH/chrome/installed-chrome.txt";

# see install.js

my $langCode     = "ja";
my $regionCode   = "JP";
my $platformNode = "unix";

my $localeType = "locale";

my $localName  = $langCode . '-' . $regionCode;
my $regionName = $regionCode;

my $chromeJarFile   = $localName . ".jar";
my $platformJarFile = $langCode . '-' . $platformNode . ".jar";
my $regionJarFile   = $regionCode . ".jar";

my @chrome =
    ("autoconfig",
     "browser",
     "communicator",
     "cookie",
     "global",
     "mozapps",
     "navigator",
     "necko",
     "p3p",
     "passwordmgr",
     "pipnss",
     "pippki");

my @platform_chrome =
    ("communicator-platform",
     "global-platform",
     "navigator-platform");

my @region_chrome =
    ("browser-region",
     "communicator-region",
     "global-region",
     "navigator-region");

foreach (@chrome) {
    register_chrome($_);
}

foreach (@platform_chrome) {
    register_platform_chrome($_);
}

foreach (@region_chrome) {
    register_region_chrome($_);
}

select_locale($localName);
select_locale($regionName);


sub register_chrome()
{
    my $name = shift;
    update_installed_chrome_file("$localeType,install,url,jar:resource:/chrome/$chromeJarFile!/$localeType/$localName/$name/");
}

sub register_platform_chrome()
{
    my $name = shift;
    update_installed_chrome_file("$localeType,install,url,jar:resource:/chrome/$platformJarFile!/$localeType/$localName/$name/");
}

sub register_region_chrome()
{
    my $name = shift;
    update_installed_chrome_file("$localeType,install,url,jar:resource:/chrome/$regionJarFile!/$localeType/$regionName/$name/");
}

sub select_locale()
{
    my $name = shift;
    update_installed_chrome_file("$localeType,install,select,$name");
}

sub update_installed_chrome_file()
{
    my $line = shift;
    my $err = 0;

    if (open(FILE, "<$installedChromeFile")) {
	while (<FILE>) {
	    chomp;
	    if ($_ =~ $line) {
		close(FILE) or $err = 1;
		if ($err) {
		    die "error: can't close $installedChromeFile: $!";
		}
		my $now = time;
		utime($now, $now, $installedChromeFile) or $err = 1;
		if ($err) {
		    die "couldn't touch $installedChromeFile";
		}
		print "+++ updating chrome $installedChromeFile\n+++\t$line\n";
		return;
	    }
	}
	close(FILE) or $err = 1;
	if ($err) {
	    die "error: can't close $installedChromeFile: $!";
	}
    }

    $err = 0;
    open(FILE, ">>$installedChromeFile") or $err = 1;
    if ($err) {
	die "can't open $installedChromeFile: $!";
    }
    print FILE "$line\n";
    close(FILE) or $err = 1;
    if ($err) {
	die "error: can't close $installedChromeFile: $!";
    }
    print "+++ adding chrome $installedChromeFile\n+++\t$line\n";
}
